/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.ref;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.apache.commons.lang.ObjectUtils;

public class MixedReference<T>
extends WeakReference<T> {
    private T strongInstance;

    public MixedReference(T instance, boolean strong) {
        this(instance, strong, null);
    }

    public MixedReference(T instance, boolean strong, ReferenceQueue<T> queue) {
        super(instance, queue);
        if (strong) {
            this.strongInstance = instance;
        }
    }

    @Override
    public T get() {
        if (this.strongInstance != null) {
            return this.strongInstance;
        }
        return super.get();
    }

    public void setStrong(boolean strong) {
        if (strong) {
            this.strongInstance = this.get();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof MixedReference) {
            MixedReference ref = (MixedReference)obj;
            return ObjectUtils.equals(this.get(), ref.get());
        }
        return false;
    }
}

