/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.ref;

import java.lang.ref.ReferenceQueue;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.epochx.life.Listener;
import org.epochx.ref.MixedReference;

public class ListenerList<T extends Listener>
extends AbstractList<T> {
    public static final long serialVersionUID = -8968847606607124719L;
    private final ReferenceQueue<T> referenceQueue;
    private final List<MixedReference<T>> data = new ArrayList<MixedReference<T>>();

    public ListenerList() {
        this.referenceQueue = new ReferenceQueue();
    }

    protected void expunge() {
        MixedReference ref;
        while ((ref = (MixedReference)this.referenceQueue.poll()) != null) {
            this.data.remove(ref);
        }
    }

    @Override
    public void add(int index, T element) {
        this.add(index, element, true);
    }

    public void add(int index, T element, boolean strong) {
        MixedReference<T> next = new MixedReference<T>(element, strong, this.referenceQueue);
        this.data.add(index, next);
        this.expunge();
    }

    public boolean add(T element, boolean strong) {
        this.expunge();
        MixedReference<T> next = new MixedReference<T>(element, strong, this.referenceQueue);
        return this.data.add(next);
    }

    @Override
    public T remove(int index) {
        MixedReference<T> removed = this.data.remove(index);
        return (T)((Listener)removed.get());
    }

    @Override
    public T set(int index, T element) {
        return this.set(index, element, true);
    }

    public T set(int index, T element, boolean strong) {
        MixedReference<T> next = new MixedReference<T>(element, strong, this.referenceQueue);
        MixedReference<T> prev = this.data.set(index, next);
        return (T)((Listener)prev.get());
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public T get(int index) {
        return (T)((Listener)this.data.get(index).get());
    }
}

