/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.op.selection;

import java.util.ArrayList;
import java.util.List;
import org.epochx.core.Model;
import org.epochx.op.ConfigOperator;
import org.epochx.op.PoolSelector;
import org.epochx.op.ProgramSelector;
import org.epochx.op.selection.RandomSelector;
import org.epochx.representation.CandidateProgram;
import org.epochx.tools.random.RandomNumberGenerator;

public class TournamentSelector
extends ConfigOperator<Model>
implements ProgramSelector,
PoolSelector {
    private final ProgramTournamentSelector poolSelection;
    private final ProgramTournamentSelector programSelection;
    private int tournamentSize;
    private RandomNumberGenerator rng;

    public TournamentSelector(RandomNumberGenerator rng, int tournamentSize) {
        this((Model)null, tournamentSize);
        this.rng = rng;
    }

    public TournamentSelector(Model model, int tournamentSize) {
        super(model);
        this.tournamentSize = tournamentSize;
        this.poolSelection = new ProgramTournamentSelector();
        this.programSelection = new ProgramTournamentSelector();
    }

    @Override
    public void onConfigure() {
        this.rng = ((Model)this.getModel()).getRNG();
    }

    @Override
    public void setSelectionPool(List<CandidateProgram> pop) {
        this.programSelection.setSelectionPool(pop);
    }

    @Override
    public CandidateProgram getProgram() {
        return this.programSelection.getProgram();
    }

    public int getTournamentSize() {
        return this.tournamentSize;
    }

    public void setTournamentSize(int tournamentSize) {
        this.tournamentSize = tournamentSize;
    }

    @Override
    public List<CandidateProgram> getPool(List<CandidateProgram> pop, int poolSize) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize must be greater than 0");
        }
        if (pop == null || pop.isEmpty()) {
            throw new IllegalArgumentException("population to select pool from must not be null nor empty");
        }
        ArrayList<CandidateProgram> pool = new ArrayList<CandidateProgram>(poolSize);
        this.poolSelection.setSelectionPool(pop);
        for (int i = 0; i < poolSize; ++i) {
            pool.add(this.poolSelection.getProgram());
        }
        return pool;
    }

    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    public void setRNG(RandomNumberGenerator rng) {
        this.rng = rng;
        this.poolSelection.randomSelector.setRNG(rng);
        this.programSelection.randomSelector.setRNG(rng);
    }

    @Override
    public void setModel(Model model) {
        super.setModel(model);
        this.poolSelection.randomSelector.setModel(model);
        this.programSelection.randomSelector.setModel(model);
    }

    private class ProgramTournamentSelector
    implements ProgramSelector {
        private final RandomSelector randomSelector;

        public ProgramTournamentSelector() {
            Object model = TournamentSelector.this.getModel();
            this.randomSelector = model == null ? new RandomSelector(TournamentSelector.this.rng) : new RandomSelector((Model)model);
        }

        @Override
        public void setSelectionPool(List<CandidateProgram> pop) {
            this.randomSelector.setSelectionPool(pop);
        }

        @Override
        public CandidateProgram getProgram() {
            CandidateProgram bestProgram = null;
            double bestFitness = Double.POSITIVE_INFINITY;
            for (int i = 0; i < TournamentSelector.this.tournamentSize; ++i) {
                CandidateProgram p = this.randomSelector.getProgram();
                double fitness = p.getFitness();
                if (!(fitness < bestFitness)) continue;
                bestFitness = fitness;
                bestProgram = p;
            }
            return bestProgram;
        }
    }
}

