/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.op.selection;

import java.util.ArrayList;
import java.util.List;
import org.epochx.core.Model;
import org.epochx.op.ConfigOperator;
import org.epochx.op.PoolSelector;
import org.epochx.op.ProgramSelector;
import org.epochx.representation.CandidateProgram;
import org.epochx.tools.random.RandomNumberGenerator;

public class RandomSelector
extends ConfigOperator<Model>
implements ProgramSelector,
PoolSelector {
    private RandomNumberGenerator rng;
    private List<CandidateProgram> pool;

    public RandomSelector(RandomNumberGenerator rng) {
        this((Model)null);
        this.rng = rng;
    }

    public RandomSelector(Model model) {
        super(model);
    }

    @Override
    public void onConfigure() {
        this.rng = ((Model)this.getModel()).getRNG();
    }

    @Override
    public void setSelectionPool(List<CandidateProgram> pool) {
        this.pool = pool;
    }

    @Override
    public CandidateProgram getProgram() {
        if (this.pool == null || this.pool.isEmpty()) {
            throw new IllegalStateException("selection pool cannot be null and must contain 1 or more CandidatePrograms");
        }
        if (this.rng == null) {
            throw new IllegalStateException("random number generator not set");
        }
        return this.pool.get(this.rng.nextInt(this.pool.size()));
    }

    @Override
    public List<CandidateProgram> getPool(List<CandidateProgram> pop, int poolSize) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize must be greater than 0");
        }
        if (pop == null || pop.isEmpty()) {
            throw new IllegalArgumentException("population to select pool from must not be null nor empty");
        }
        if (this.rng == null) {
            throw new IllegalStateException("random number generator not set");
        }
        ArrayList<CandidateProgram> pool = new ArrayList<CandidateProgram>(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            pool.add(pop.get(this.rng.nextInt(pop.size())));
        }
        return pool;
    }

    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    public void setRNG(RandomNumberGenerator rng) {
        this.rng = rng;
    }
}

