/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.op.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.epochx.core.Model;
import org.epochx.op.ConfigOperator;
import org.epochx.op.PoolSelector;
import org.epochx.op.ProgramSelector;
import org.epochx.representation.CandidateProgram;
import org.epochx.tools.random.RandomNumberGenerator;

public class LinearRankSelector
extends ConfigOperator<Model>
implements ProgramSelector,
PoolSelector {
    private final ProgramLinearRankSelector programSelection;
    private final ProgramLinearRankSelector poolSelection;
    private RandomNumberGenerator rng;
    private double gradient;
    private double nPlus;
    private double nMinus;

    public LinearRankSelector(RandomNumberGenerator rng) {
        this((Model)null);
        this.rng = rng;
    }

    public LinearRankSelector(RandomNumberGenerator rng, double gradient) {
        this((Model)null, gradient);
        this.rng = rng;
    }

    public LinearRankSelector(Model model) {
        this(model, 0.2);
    }

    public LinearRankSelector(Model model, double gradient) {
        super(model);
        this.setGradient(gradient);
        this.programSelection = new ProgramLinearRankSelector();
        this.poolSelection = new ProgramLinearRankSelector();
    }

    @Override
    public void onConfigure() {
        this.rng = ((Model)this.getModel()).getRNG();
    }

    public void setGradient(double gradient) {
        if (gradient < 0.0 || gradient > 1.0) {
            throw new IllegalArgumentException("linear rank gradient must be between 0.0 and 1.0");
        }
        this.gradient = gradient;
        this.nMinus = 2.0 / (gradient + 1.0);
        this.nPlus = 2.0 * gradient / (gradient + 1.0);
        assert (this.nMinus + this.nPlus == 2.0);
    }

    public double getGradient() {
        return this.gradient;
    }

    public double getWorstProbability(int popSize) {
        return this.nPlus / (double)popSize;
    }

    public double getBestProbability(int popSize) {
        return this.nMinus / (double)popSize;
    }

    @Override
    public void setSelectionPool(List<CandidateProgram> pool) {
        this.programSelection.setSelectionPool(pool);
    }

    @Override
    public CandidateProgram getProgram() {
        return this.programSelection.getProgram();
    }

    @Override
    public List<CandidateProgram> getPool(List<CandidateProgram> pop, int poolSize) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize must be greater than 0");
        }
        if (pop == null || pop.isEmpty()) {
            throw new IllegalArgumentException("population to select pool from must not be null nor empty");
        }
        this.poolSelection.setSelectionPool(pop);
        ArrayList<CandidateProgram> pool = new ArrayList<CandidateProgram>();
        for (int i = 0; i < poolSize; ++i) {
            pool.add(this.poolSelection.getProgram());
        }
        return pool;
    }

    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    public void setRNG(RandomNumberGenerator rng) {
        this.rng = rng;
    }

    private class ProgramLinearRankSelector
    implements ProgramSelector {
        private List<CandidateProgram> pool;
        private double[] probabilities;

        private ProgramLinearRankSelector() {
        }

        @Override
        public void setSelectionPool(List<CandidateProgram> pool) {
            if (pool == null || pool.isEmpty()) {
                throw new IllegalArgumentException("selection pool cannot be null and must contain 1 or more CandidatePrograms");
            }
            this.pool = pool;
            Collections.sort(pool, Collections.reverseOrder());
            int popSize = pool.size();
            this.probabilities = new double[popSize];
            double total = 0.0;
            for (int i = 0; i < popSize; ++i) {
                int n = popSize - i;
                double p = 1.0 / (double)popSize * (LinearRankSelector.this.nMinus + (LinearRankSelector.this.nPlus - LinearRankSelector.this.nMinus) * (((double)n - 1.0) / ((double)popSize - 1.0)));
                this.probabilities[i] = total += p;
            }
            this.probabilities[popSize - 1] = 1.0;
        }

        @Override
        public CandidateProgram getProgram() {
            if (LinearRankSelector.this.rng == null) {
                throw new IllegalStateException("random number generator not set");
            }
            double ran = LinearRankSelector.this.rng.nextDouble();
            assert (ran >= 0.0 && ran <= 1.0);
            for (int i = 0; i < this.probabilities.length; ++i) {
                if (!(ran <= this.probabilities[i])) continue;
                return this.pool.get(i);
            }
            assert (false);
            return null;
        }
    }
}

