/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.op.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.epochx.core.Model;
import org.epochx.op.ConfigOperator;
import org.epochx.op.PoolSelector;
import org.epochx.op.ProgramSelector;
import org.epochx.representation.CandidateProgram;
import org.epochx.tools.random.RandomNumberGenerator;

public class FitnessProportionateSelector
extends ConfigOperator<Model>
implements ProgramSelector,
PoolSelector {
    private final ProgramFitnessProportionateSelector programSelection;
    private final ProgramFitnessProportionateSelector poolSelection;
    private RandomNumberGenerator rng;
    private boolean overSelection;

    public FitnessProportionateSelector(RandomNumberGenerator rng) {
        this((Model)null, false);
    }

    public FitnessProportionateSelector(RandomNumberGenerator rng, boolean overSelection) {
        this((Model)null, overSelection);
    }

    public FitnessProportionateSelector(Model model) {
        this(model, false);
    }

    public FitnessProportionateSelector(Model model, boolean overSelection) {
        super(model);
        this.overSelection = overSelection;
        this.programSelection = new ProgramFitnessProportionateSelector();
        this.poolSelection = new ProgramFitnessProportionateSelector();
    }

    @Override
    public void onConfigure() {
        this.rng = ((Model)this.getModel()).getRNG();
    }

    @Override
    public void setSelectionPool(List<CandidateProgram> pool) {
        this.programSelection.setSelectionPool(pool);
    }

    @Override
    public CandidateProgram getProgram() {
        return this.programSelection.getProgram();
    }

    @Override
    public List<CandidateProgram> getPool(List<CandidateProgram> pop, int poolSize) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize must be greater than 0");
        }
        if (pop == null || pop.isEmpty()) {
            throw new IllegalArgumentException("population to select pool from must not be null nor empty");
        }
        this.poolSelection.setSelectionPool(pop);
        ArrayList<CandidateProgram> pool = new ArrayList<CandidateProgram>();
        for (int i = 0; i < poolSize; ++i) {
            pool.add(this.poolSelection.getProgram());
        }
        return pool;
    }

    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    public void setRNG(RandomNumberGenerator rng) {
        this.rng = rng;
    }

    public boolean isOverSelectionEnabled() {
        return this.overSelection;
    }

    public void setOverSelectionEnabled(boolean overSelection) {
        this.overSelection = overSelection;
        if (this.programSelection.pool != null) {
            this.setSelectionPool(this.programSelection.pool);
        }
    }

    protected double getOverSelectionProportion(int popSize) {
        double proportion = 0.32;
        for (int delimiter = 1000; popSize > delimiter; delimiter *= 2) {
            proportion /= 2.0;
        }
        return proportion;
    }

    private class ProgramFitnessProportionateSelector
    implements ProgramSelector {
        private List<CandidateProgram> pool;
        private double[] normalised;
        private double overSelectionProportion;

        private ProgramFitnessProportionateSelector() {
        }

        @Override
        public void setSelectionPool(List<CandidateProgram> pool) {
            if (pool == null || pool.isEmpty()) {
                throw new IllegalArgumentException("selection pool cannot be null and must contain 1 or more CandidatePrograms");
            }
            this.pool = pool;
            if (FitnessProportionateSelector.this.overSelection) {
                Collections.sort(pool, Collections.reverseOrder());
            }
            this.overSelectionProportion = FitnessProportionateSelector.this.getOverSelectionProportion(pool.size());
            double[] adjusted = new double[pool.size()];
            double adjustedSum = 0.0;
            for (int i = 0; i < adjusted.length; ++i) {
                double adjustedFitness;
                adjusted[i] = adjustedFitness = pool.get(i).getAdjustedFitness();
                adjustedSum += adjustedFitness;
            }
            this.normalised = new double[pool.size()];
            double normalisedSum = 0.0;
            for (int i = 0; i < this.normalised.length; ++i) {
                this.normalised[i] = normalisedSum += adjusted[i] / adjustedSum;
            }
            this.normalised[this.normalised.length - 1] = 1.0;
        }

        @Override
        public CandidateProgram getProgram() {
            if (this.pool == null || this.pool.isEmpty()) {
                throw new IllegalStateException("selection pool cannot be null and must contain 1 or more CandidatePrograms");
            }
            if (FitnessProportionateSelector.this.rng == null) {
                throw new IllegalStateException("random number generator not set");
            }
            double ran = FitnessProportionateSelector.this.rng.nextDouble();
            if (FitnessProportionateSelector.this.overSelection) {
                ran = FitnessProportionateSelector.this.rng.nextDouble() < 0.8 ? (ran *= this.overSelectionProportion) : ran * (1.0 - this.overSelectionProportion) + this.overSelectionProportion;
            }
            assert (ran >= 0.0 && ran <= 1.0);
            for (int i = 0; i < this.normalised.length; ++i) {
                if (!(ran <= this.normalised[i])) continue;
                return this.pool.get(i);
            }
            assert (false);
            return null;
        }
    }
}

