/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.life;

import java.util.Iterator;
import java.util.List;
import org.epochx.life.ConfigListener;
import org.epochx.life.CrossoverListener;
import org.epochx.life.ElitismListener;
import org.epochx.life.GenerationListener;
import org.epochx.life.Hook;
import org.epochx.life.InitialisationListener;
import org.epochx.life.MutationListener;
import org.epochx.life.PoolSelectionListener;
import org.epochx.life.ReproductionListener;
import org.epochx.life.RunListener;
import org.epochx.ref.ListenerList;
import org.epochx.representation.CandidateProgram;

public class Life {
    private static Life instance;
    private final ListenerList<ConfigListener> configListeners = new ListenerList();
    private final ListenerList<RunListener> runListeners = new ListenerList();
    private final ListenerList<InitialisationListener> initialisationListeners = new ListenerList();
    private final ListenerList<ElitismListener> elitismListeners = new ListenerList();
    private final ListenerList<PoolSelectionListener> poolSelectionListeners = new ListenerList();
    private final ListenerList<CrossoverListener> crossoverListeners = new ListenerList();
    private final ListenerList<MutationListener> mutationListeners = new ListenerList();
    private final ListenerList<ReproductionListener> reproductionListeners = new ListenerList();
    private final ListenerList<GenerationListener> generationListeners = new ListenerList();
    private final ListenerList<Hook> hooks = new ListenerList();

    private Life() {
    }

    public static Life get() {
        if (instance == null) {
            instance = new Life();
        }
        return instance;
    }

    public void addHook(Hook hook) {
        this.hooks.add(hook);
    }

    public void addHook(Hook hook, boolean strong) {
        this.hooks.add(hook, strong);
    }

    public void insertHook(int index, Hook hook) {
        this.hooks.add(index, hook);
    }

    public void insertHook(int index, Hook hook, boolean strong) {
        this.hooks.add(index, hook, strong);
    }

    public void removeHook(InitialisationListener hook) {
        this.hooks.remove(hook);
    }

    public void addConfigListener(ConfigListener listener) {
        this.addConfigListener(listener, true);
    }

    public void addConfigListener(ConfigListener listener, boolean strong) {
        this.configListeners.add(listener, strong);
    }

    public void removeConfigListener(ConfigListener listener) {
        this.configListeners.remove(listener);
    }

    public void addRunListener(RunListener listener) {
        this.runListeners.add(listener);
    }

    public void addRunListener(RunListener listener, boolean strong) {
        this.runListeners.add(listener, strong);
    }

    public void removeRunListener(RunListener listener) {
        this.runListeners.remove(listener);
    }

    public void addInitialisationListener(InitialisationListener listener) {
        this.initialisationListeners.add(listener);
    }

    public void addInitialisationListener(InitialisationListener listener, boolean strong) {
        this.initialisationListeners.add(listener, strong);
    }

    public void removeInitialisationListener(InitialisationListener listener) {
        this.initialisationListeners.remove(listener);
    }

    public void addElitismListener(ElitismListener listener) {
        this.elitismListeners.add(listener);
    }

    public void addElitismListener(ElitismListener listener, boolean strong) {
        this.elitismListeners.add(listener, strong);
    }

    public void removeElitismListener(ElitismListener listener) {
        this.elitismListeners.remove(listener);
    }

    public void addPoolSelectionListener(PoolSelectionListener listener) {
        this.poolSelectionListeners.add(listener);
    }

    public void addPoolSelectionListener(PoolSelectionListener listener, boolean strong) {
        this.poolSelectionListeners.add(listener, strong);
    }

    public void removePoolSelectionListener(PoolSelectionListener listener) {
        this.poolSelectionListeners.remove(listener);
    }

    public void addCrossoverListener(CrossoverListener listener) {
        this.crossoverListeners.add(listener);
    }

    public void addCrossoverListener(CrossoverListener listener, boolean strong) {
        this.crossoverListeners.add(listener, strong);
    }

    public void removeCrossoverListener(CrossoverListener listener) {
        this.crossoverListeners.remove(listener);
    }

    public void addMutationListener(MutationListener listener) {
        this.mutationListeners.add(listener);
    }

    public void addMutationListener(MutationListener listener, boolean strong) {
        this.mutationListeners.add(listener, strong);
    }

    public void removeMutationListener(MutationListener listener) {
        this.mutationListeners.remove(listener);
    }

    public void addReproductionListener(ReproductionListener listener) {
        this.reproductionListeners.add(listener);
    }

    public void addReproductionListener(ReproductionListener listener, boolean strong) {
        this.reproductionListeners.add(listener, strong);
    }

    public void removeReproductionListener(ReproductionListener listener) {
        this.reproductionListeners.remove(listener);
    }

    public void addGenerationListener(GenerationListener listener) {
        this.generationListeners.add(listener);
    }

    public void addGenerationListener(GenerationListener listener, boolean strong) {
        this.generationListeners.add(listener, strong);
    }

    public void removeGenerationListener(GenerationListener listener) {
        this.generationListeners.remove(listener);
    }

    public void fireConfigureEvent() {
        for (ConfigListener listener : this.configListeners) {
            if (listener == null) continue;
            listener.onConfigure();
        }
    }

    public void fireRunStartEvent() {
        for (RunListener listener : this.runListeners) {
            listener.onRunStart();
        }
    }

    public void fireSuccessEvent() {
        for (RunListener listener : this.runListeners) {
            listener.onSuccess();
        }
    }

    public void fireRunEndEvent() {
        for (RunListener listener : this.runListeners) {
            listener.onRunEnd();
        }
    }

    public void fireInitialisationStartEvent() {
        for (InitialisationListener listener : this.initialisationListeners) {
            listener.onInitialisationStart();
        }
    }

    public void fireInitialisationEndEvent() {
        for (InitialisationListener listener : this.initialisationListeners) {
            listener.onInitialisationEnd();
        }
    }

    public void fireElitismStartEvent() {
        for (ElitismListener listener : this.elitismListeners) {
            listener.onElitismStart();
        }
    }

    public void fireElitismEndEvent() {
        for (ElitismListener listener : this.elitismListeners) {
            listener.onElitismEnd();
        }
    }

    public void firePoolSelectionStartEvent() {
        for (PoolSelectionListener listener : this.poolSelectionListeners) {
            listener.onPoolSelectionStart();
        }
    }

    public void firePoolSelectionEndEvent() {
        for (PoolSelectionListener listener : this.poolSelectionListeners) {
            listener.onPoolSelectionEnd();
        }
    }

    public void fireCrossoverStartEvent() {
        for (CrossoverListener listener : this.crossoverListeners) {
            listener.onCrossoverStart();
        }
    }

    public void fireCrossoverEndEvent() {
        for (CrossoverListener listener : this.crossoverListeners) {
            listener.onCrossoverEnd();
        }
    }

    public void fireMutationStartEvent() {
        for (MutationListener listener : this.mutationListeners) {
            listener.onMutationStart();
        }
    }

    public void fireMutationEndEvent() {
        for (MutationListener listener : this.mutationListeners) {
            listener.onMutationEnd();
        }
    }

    public void fireReproductionStartEvent() {
        for (ReproductionListener listener : this.reproductionListeners) {
            listener.onReproductionStart();
        }
    }

    public void fireReproductionEndEvent() {
        for (ReproductionListener listener : this.reproductionListeners) {
            listener.onReproductionEnd();
        }
    }

    public void fireGenerationStartEvent() {
        for (GenerationListener listener : this.generationListeners) {
            listener.onGenerationStart();
        }
    }

    public void fireGenerationEndEvent() {
        for (GenerationListener listener : this.generationListeners) {
            listener.onGenerationEnd();
        }
    }

    public List<CandidateProgram> runInitialisationHooks(List<CandidateProgram> pop) {
        Hook h;
        Iterator iterator = this.hooks.iterator();
        while (iterator.hasNext() && (pop = (h = (Hook)iterator.next()).initialisationHook(pop)) != null) {
        }
        return pop;
    }

    public List<CandidateProgram> runElitismHooks(List<CandidateProgram> elites) {
        for (Hook h : this.hooks) {
            elites = h.elitismHook(elites);
            if (elites != null) continue;
            throw new NullPointerException("an elitism hook returned elites as null");
        }
        assert (elites != null);
        return elites;
    }

    public List<CandidateProgram> runPoolSelectionHooks(List<CandidateProgram> pool) {
        Hook h;
        Iterator iterator = this.hooks.iterator();
        while (iterator.hasNext() && (pool = (h = (Hook)iterator.next()).poolSelectionHook(pool)) != null) {
        }
        return pool;
    }

    public CandidateProgram[] runCrossoverHooks(CandidateProgram[] parents, CandidateProgram[] children) {
        Hook h;
        Iterator iterator = this.hooks.iterator();
        while (iterator.hasNext() && (children = (h = (Hook)iterator.next()).crossoverHook(parents, children)) != null) {
        }
        return children;
    }

    public CandidateProgram runMutationHooks(CandidateProgram parent, CandidateProgram child) {
        Hook h;
        Iterator iterator = this.hooks.iterator();
        while (iterator.hasNext() && (child = (h = (Hook)iterator.next()).mutationHook(parent, child)) != null) {
        }
        return child;
    }

    public CandidateProgram runReproductionHooks(CandidateProgram program) {
        Hook h;
        Iterator iterator = this.hooks.iterator();
        while (iterator.hasNext() && (program = (h = (Hook)iterator.next()).reproductionHook(program)) != null) {
        }
        return program;
    }

    public List<CandidateProgram> runGenerationHooks(List<CandidateProgram> pop) {
        Hook h;
        Iterator iterator = this.hooks.iterator();
        while (iterator.hasNext() && (pop = (h = (Hook)iterator.next()).generationHook(pop)) != null) {
        }
        return pop;
    }

    public void clearListeners() {
        this.configListeners.clear();
        this.runListeners.clear();
        this.initialisationListeners.clear();
        this.elitismListeners.clear();
        this.poolSelectionListeners.clear();
        this.crossoverListeners.clear();
        this.mutationListeners.clear();
        this.reproductionListeners.clear();
        this.generationListeners.clear();
    }

    public void clearHooks() {
        this.hooks.clear();
    }
}

