/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.gr.stats;

import java.util.List;
import org.apache.commons.lang.math.NumberUtils;
import org.epochx.gr.representation.GRCandidateProgram;
import org.epochx.stats.AbstractStat;
import org.epochx.stats.Stat;
import org.epochx.stats.StatField;
import org.epochx.stats.Stats;
import org.epochx.stats.StatsUtils;

public class GRStatField
extends StatField {
    public static final Stat GEN_DEPTHS = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            int[] depths = null;
            List pop = (List)Stats.get().getStat(StatField.GEN_POP);
            if (pop != null) {
                depths = new int[pop.size()];
                for (int i = 0; i < pop.size(); ++i) {
                    depths[i] = ((GRCandidateProgram)pop.get(i)).getDepth();
                }
            }
            return depths;
        }
    };
    public static final Stat GEN_DEPTH_AVE = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            Double aveDepth = null;
            int[] depths = (int[])Stats.get().getStat(GEN_DEPTHS);
            if (depths != null) {
                aveDepth = StatsUtils.ave(depths);
            }
            return aveDepth;
        }
    };
    public static final Stat GEN_DEPTH_STDEV = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            Double stdevDepth = null;
            int[] depths = (int[])Stats.get().getStat(GEN_DEPTHS);
            if (depths != null) {
                stdevDepth = StatsUtils.stdev(depths);
            }
            return stdevDepth;
        }
    };
    public static final Stat GEN_DEPTH_MAX = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            Integer maxDepth = null;
            int[] depths = (int[])Stats.get().getStat(GEN_DEPTHS);
            if (depths != null) {
                maxDepth = NumberUtils.max((int[])depths);
            }
            return maxDepth;
        }
    };
    public static final Stat GEN_DEPTH_MIN = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            Integer minDepth = null;
            int[] depths = (int[])Stats.get().getStat(GEN_DEPTHS);
            if (depths != null) {
                minDepth = NumberUtils.min((int[])depths);
            }
            return minDepth;
        }
    };
}

