/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.gr.representation;

import org.epochx.gr.model.GRModel;
import org.epochx.representation.CandidateProgram;
import org.epochx.tools.grammar.NonTerminalSymbol;

public class GRCandidateProgram
extends CandidateProgram {
    private GRModel model;
    private NonTerminalSymbol parseTree;
    private double fitness;
    private String sourceCache;

    public GRCandidateProgram(GRModel model) {
        this(null, model);
    }

    public GRCandidateProgram(NonTerminalSymbol parseTree, GRModel model) {
        this.model = model;
        this.parseTree = parseTree;
        this.sourceCache = null;
    }

    public void setParseTree(NonTerminalSymbol parseTree) {
        this.parseTree = parseTree;
    }

    @Override
    public double getFitness() {
        String source = null;
        if (this.model.cacheFitness()) {
            source = this.getSourceCode();
        }
        if (!this.model.cacheFitness() || !source.equals(this.sourceCache)) {
            this.fitness = this.model.getFitness(this);
            this.sourceCache = source;
        }
        return this.fitness;
    }

    public double getFitnessValue() {
        return this.fitness;
    }

    public void setFitnessValue(double fitnessValue) {
        this.fitness = fitnessValue;
    }

    @Override
    public boolean isValid() {
        boolean valid = true;
        int maxProgramDepth = this.model.getMaxDepth();
        if (maxProgramDepth != -1 && this.getDepth() > maxProgramDepth) {
            valid = false;
        }
        return valid;
    }

    public String getSourceCode() {
        return this.parseTree.toString();
    }

    public NonTerminalSymbol getParseTree() {
        return this.parseTree;
    }

    public int getDepth() {
        return this.parseTree.getDepth();
    }

    public void reset() {
        this.setFitnessValue(0.0);
    }

    @Override
    public CandidateProgram clone() {
        GRCandidateProgram clone = (GRCandidateProgram)super.clone();
        clone.parseTree = this.parseTree == null ? null : this.parseTree.clone();
        clone.sourceCache = this.sourceCache;
        clone.fitness = this.fitness;
        clone.model = this.model;
        return clone;
    }

    public String toString() {
        if (this.parseTree != null) {
            return this.parseTree.toString();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof GRCandidateProgram) {
            GRCandidateProgram prog = (GRCandidateProgram)o;
            return prog.toString().equals(this.toString());
        }
        return false;
    }

    @Override
    public int compareTo(CandidateProgram o) {
        double objFitness;
        if (o == null) {
            throw new NullPointerException("cannot compare to null");
        }
        double thisFitness = this.getFitnessValue();
        if (thisFitness < (objFitness = ((GRCandidateProgram)o).getFitnessValue())) {
            return -1;
        }
        if (thisFitness == objFitness) {
            return 0;
        }
        return 1;
    }
}

