/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.gr.op.mutation;

import java.util.List;
import org.epochx.gr.model.GRModel;
import org.epochx.gr.op.init.GrowInitialiser;
import org.epochx.gr.op.mutation.GRMutation;
import org.epochx.gr.representation.GRCandidateProgram;
import org.epochx.op.ConfigOperator;
import org.epochx.representation.CandidateProgram;
import org.epochx.stats.AbstractStat;
import org.epochx.stats.Stat;
import org.epochx.stats.Stats;
import org.epochx.tools.grammar.GrammarRule;
import org.epochx.tools.grammar.NonTerminalSymbol;
import org.epochx.tools.random.RandomNumberGenerator;

public class WhighamMutation
extends ConfigOperator<GRModel>
implements GRMutation {
    public static final Stat MUT_POINT = new AbstractStat(Stats.ExpiryEvent.MUTATION){};
    public static final Stat MUT_SUBTREE = new AbstractStat(Stats.ExpiryEvent.MUTATION){};
    private RandomNumberGenerator rng;
    private final GrowInitialiser grower;
    private int n_labels;
    private int n_attributes;

    public WhighamMutation(RandomNumberGenerator rng, int labels, int attributes) {
        this((GRModel)null);
        this.rng = rng;
        this.grower.setRNG(rng);
        this.n_labels = labels;
        this.n_attributes = attributes;
        this.grower.setNAttributes(this.n_attributes);
        this.grower.setNLabels(this.n_labels);
    }

    public WhighamMutation(RandomNumberGenerator rng) {
        this((GRModel)null);
        this.rng = rng;
        this.grower.setRNG(rng);
        this.grower.setNAttributes(0);
        this.grower.setNLabels(0);
    }

    public WhighamMutation(GRModel model) {
        super(model);
        this.grower = new GrowInitialiser(model, this.n_labels, this.n_attributes);
    }

    @Override
    public void onConfigure() {
        this.rng = ((GRModel)this.getModel()).getRNG();
    }

    @Override
    public GRCandidateProgram mutate(CandidateProgram program) {
        GRCandidateProgram mutatedProgram = (GRCandidateProgram)program.clone();
        NonTerminalSymbol parseTree = mutatedProgram.getParseTree();
        List<Integer> nonTerminals = parseTree.getNonTerminalIndexes();
        int point = nonTerminals.get(this.rng.nextInt(nonTerminals.size()));
        NonTerminalSymbol original = (NonTerminalSymbol)parseTree.getNthSymbol(point);
        int originalDepth = original.getDepth();
        Stats.get().addData(MUT_POINT, point);
        GrammarRule rule = original.getGrammarRule();
        NonTerminalSymbol subtree = this.grower.getGrownParseTree(originalDepth, rule);
        Stats.get().addData(MUT_SUBTREE, subtree);
        if (point == 0) {
            mutatedProgram.setParseTree(subtree);
        } else {
            parseTree.setNthSymbol(point, subtree);
        }
        return mutatedProgram;
    }

    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    public void setRNG(RandomNumberGenerator rng) {
        this.rng = rng;
        this.grower.setRNG(rng);
    }
}

