/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.gr.op.init;

import java.util.ArrayList;
import java.util.List;
import org.epochx.gr.model.GRModel;
import org.epochx.gr.op.init.FullInitialiser;
import org.epochx.gr.op.init.GRInitialiser;
import org.epochx.gr.op.init.GrowInitialiser;
import org.epochx.gr.representation.GRCandidateProgram;
import org.epochx.op.ConfigOperator;
import org.epochx.representation.CandidateProgram;
import org.epochx.tools.grammar.Grammar;
import org.epochx.tools.random.RandomNumberGenerator;

public class RampedHalfAndHalfInitialiser
extends ConfigOperator<GRModel>
implements GRInitialiser {
    private Grammar grammar;
    private int popSize;
    private int endMaxDepth;
    private int startMaxDepth;
    private boolean acceptDuplicates;
    private final GrowInitialiser grow;
    private final FullInitialiser full;

    public RampedHalfAndHalfInitialiser(RandomNumberGenerator rng, Grammar grammar, int popSize, int startMaxDepth, int endMaxDepth, boolean acceptDuplicates) {
        this(null, startMaxDepth, acceptDuplicates);
        this.endMaxDepth = endMaxDepth;
        this.grammar = grammar;
        this.popSize = popSize;
        this.acceptDuplicates = acceptDuplicates;
        this.grow.setGrammar(grammar);
        this.grow.setRNG(rng);
        this.full.setGrammar(grammar);
        this.full.setRNG(rng);
    }

    public RampedHalfAndHalfInitialiser(GRModel model) {
        this(model, -1);
    }

    public RampedHalfAndHalfInitialiser(GRModel model, int startMaxDepth) {
        this(model, startMaxDepth, true);
    }

    public RampedHalfAndHalfInitialiser(GRModel model, int startMaxDepth, boolean acceptDuplicates) {
        super(model);
        this.startMaxDepth = startMaxDepth;
        this.acceptDuplicates = acceptDuplicates;
        this.grow = new GrowInitialiser(model, acceptDuplicates);
        this.full = new FullInitialiser(model, acceptDuplicates);
    }

    @Override
    public void onConfigure() {
        this.grammar = ((GRModel)this.getModel()).getGrammar();
        this.popSize = ((GRModel)this.getModel()).getPopulationSize();
        this.endMaxDepth = ((GRModel)this.getModel()).getMaxInitialDepth();
    }

    @Override
    public List<CandidateProgram> getInitialPopulation() {
        if (this.popSize < 1) {
            throw new IllegalStateException("Population size must be 1 or greater");
        }
        if (this.grammar == null) {
            throw new IllegalStateException("No grammar has been set");
        }
        ArrayList<CandidateProgram> firstGen = new ArrayList<CandidateProgram>(this.popSize);
        int startDepth = this.startMaxDepth;
        int minDepthPossible = this.grammar.getMinimumDepth();
        if (this.startMaxDepth < minDepthPossible) {
            startDepth = minDepthPossible;
        }
        if (this.endMaxDepth < startDepth) {
            throw new IllegalStateException("End maximum depth must be greater than the minimum possible depth.");
        }
        double programsPerDepth = (double)this.popSize / (double)(this.endMaxDepth - startDepth + 1);
        for (int i = 0; i < this.popSize; ++i) {
            GRCandidateProgram program;
            int depth = (int)Math.floor((double)i / programsPerDepth + (double)startDepth);
            do {
                if (i % 2 == 0) {
                    this.grow.setMaxDepth(depth);
                    program = this.grow.getInitialProgram();
                    continue;
                }
                this.full.setDepth(depth);
                program = this.full.getInitialProgram();
            } while (!this.acceptDuplicates && firstGen.contains(program));
            firstGen.add(program);
        }
        return firstGen;
    }

    public boolean isDuplicatesEnabled() {
        return this.acceptDuplicates;
    }

    public void setDuplicatesEnabled(boolean acceptDuplicates) {
        this.acceptDuplicates = acceptDuplicates;
    }

    @Override
    public void setModel(GRModel model) {
        super.setModel(model);
        this.grow.setModel(model);
        this.full.setModel(model);
    }

    public void setRNG(RandomNumberGenerator rng) {
        this.grow.setRNG(rng);
        this.full.setRNG(rng);
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public void setGrammar(Grammar grammar) {
        this.grammar = grammar;
        this.grow.setGrammar(grammar);
        this.full.setGrammar(grammar);
    }

    public int getPopSize() {
        return this.popSize;
    }

    public void setPopSize(int popSize) {
        this.popSize = popSize;
    }

    public int getEndMaxDepth() {
        return this.endMaxDepth;
    }

    public void setEndMaxDepth(int endMaxDepth) {
        this.endMaxDepth = endMaxDepth;
    }

    public int getStartMaxDepth() {
        return this.startMaxDepth;
    }

    public void setStartMaxDepth(int startMaxDepth) {
        this.startMaxDepth = startMaxDepth;
    }
}

