/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.gr.op.init;

import java.util.ArrayList;
import java.util.List;
import org.epochx.gr.model.GRModel;
import org.epochx.gr.op.init.GRInitialiser;
import org.epochx.gr.representation.GRCandidateProgram;
import org.epochx.op.ConfigOperator;
import org.epochx.representation.CandidateProgram;
import org.epochx.tools.grammar.Grammar;
import org.epochx.tools.grammar.GrammarLiteral;
import org.epochx.tools.grammar.GrammarNode;
import org.epochx.tools.grammar.GrammarProduction;
import org.epochx.tools.grammar.GrammarRule;
import org.epochx.tools.grammar.NonTerminalSymbol;
import org.epochx.tools.grammar.TerminalSymbol;
import org.epochx.tools.random.RandomNumberGenerator;

public class FullInitialiser
extends ConfigOperator<GRModel>
implements GRInitialiser {
    private RandomNumberGenerator rng;
    private Grammar grammar;
    private int popSize;
    private int depth;
    private boolean acceptDuplicates;

    public FullInitialiser(RandomNumberGenerator rng, Grammar grammar, int popSize, int depth, boolean acceptDuplicates) {
        this(null, acceptDuplicates);
        this.rng = rng;
        this.grammar = grammar;
        this.popSize = popSize;
        this.depth = depth;
    }

    public FullInitialiser(GRModel model, int n_labels, int n_attributes) {
        this(model, true);
    }

    public FullInitialiser(GRModel model, boolean acceptDuplicates) {
        super(model);
        this.acceptDuplicates = acceptDuplicates;
    }

    @Override
    public void onConfigure() {
        this.rng = ((GRModel)this.getModel()).getRNG();
        this.grammar = ((GRModel)this.getModel()).getGrammar();
        this.popSize = ((GRModel)this.getModel()).getPopulationSize();
        this.depth = ((GRModel)this.getModel()).getMaxInitialDepth();
    }

    @Override
    public List<CandidateProgram> getInitialPopulation() {
        if (this.popSize < 1) {
            throw new IllegalStateException("Population size must be 1 or greater");
        }
        ArrayList<CandidateProgram> firstGen = new ArrayList<CandidateProgram>(this.popSize);
        for (int i = 0; i < this.popSize; ++i) {
            GRCandidateProgram candidate;
            do {
                candidate = this.getInitialProgram();
            } while (!this.acceptDuplicates && firstGen.contains(candidate));
            firstGen.add(candidate);
        }
        return firstGen;
    }

    public GRCandidateProgram getInitialProgram() {
        if (this.rng == null) {
            throw new IllegalStateException("No random number generator has been set");
        }
        if (this.grammar == null) {
            throw new IllegalStateException("No grammar has been set");
        }
        GrammarRule startRule = this.grammar.getStartRule();
        int minDepth = startRule.getMinDepth();
        if (minDepth > this.depth) {
            throw new IllegalStateException("No possible programs within given max depth parameter for this grammar.");
        }
        NonTerminalSymbol parseTree = new NonTerminalSymbol(startRule);
        this.buildDerivationTree(parseTree, startRule, 0, this.depth);
        return new GRCandidateProgram(parseTree, (GRModel)this.getModel());
    }

    private void buildDerivationTree(NonTerminalSymbol parseTree, GrammarRule rule, int currentDepth, int maxDepth) {
        int productionIndex = 0;
        int noProductions = rule.getNoProductions();
        if (noProductions > 1) {
            List<Integer> validProductions = this.getValidProductionIndexes(rule.getProductions(), maxDepth - currentDepth - 1);
            int chosenProduction = this.rng.nextInt(validProductions.size());
            productionIndex = validProductions.get(chosenProduction);
        }
        GrammarProduction p = rule.getProduction(productionIndex);
        List<GrammarNode> grammarNodes = p.getGrammarNodes();
        for (GrammarNode node : grammarNodes) {
            if (node instanceof GrammarRule) {
                GrammarRule r = (GrammarRule)node;
                NonTerminalSymbol nt = new NonTerminalSymbol((GrammarRule)node);
                this.buildDerivationTree(nt, r, currentDepth + 1, maxDepth);
                parseTree.addChild(nt);
                continue;
            }
            String nodeStr = node.toString();
            if (nodeStr.startsWith("RANDFLOAT(")) {
                String[] interval = nodeStr.substring(10, nodeStr.length() - 2).split(",");
                double rangeMin = Double.parseDouble(interval[0]);
                double rangeMax = Double.parseDouble(interval[1]);
                double randomValue = rangeMin + (rangeMax - rangeMin) * this.rng.nextDouble();
                parseTree.addChild(new TerminalSymbol(new GrammarLiteral(randomValue + "")));
                continue;
            }
            if (nodeStr.startsWith("RANDINT_TYPE0(") || nodeStr.startsWith("RANDINTEGER(")) {
                int start = 14;
                if (nodeStr.startsWith("RANDINTEGER(")) {
                    start = 12;
                }
                String[] interval = nodeStr.substring(start, nodeStr.length() - 2).split(",");
                int rangeMin = Integer.parseInt(interval[0]);
                int rangeMax = Integer.parseInt(interval[1]);
                int randomValue = rangeMin + this.rng.nextInt(rangeMax - rangeMin + 1);
                parseTree.addChild(new TerminalSymbol(new GrammarLiteral(randomValue + "")));
                continue;
            }
            parseTree.addChild(new TerminalSymbol((GrammarLiteral)node));
        }
    }

    private List<Integer> getValidProductionIndexes(List<GrammarProduction> grammarProductions, int maxDepth) {
        ArrayList<Integer> validRecursive = new ArrayList<Integer>();
        ArrayList<Integer> validAll = new ArrayList<Integer>();
        for (int i = 0; i < grammarProductions.size(); ++i) {
            GrammarProduction p = grammarProductions.get(i);
            if (p.getMinDepth() > maxDepth) continue;
            validAll.add(i);
            if (!p.isRecursive()) continue;
            validRecursive.add(i);
        }
        return validRecursive.isEmpty() ? validAll : validRecursive;
    }

    public boolean isDuplicatesEnabled() {
        return this.acceptDuplicates;
    }

    public void setDuplicatesEnabled(boolean acceptDuplicates) {
        this.acceptDuplicates = acceptDuplicates;
    }

    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    public void setRNG(RandomNumberGenerator rng) {
        this.rng = rng;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public void setGrammar(Grammar grammar) {
        this.grammar = grammar;
    }

    public int getPopSize() {
        return this.popSize;
    }

    public void setPopSize(int popSize) {
        this.popSize = popSize;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }
}

