/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.gr.op.crossover;

import java.util.ArrayList;
import java.util.List;
import org.epochx.gr.model.GRModel;
import org.epochx.gr.op.crossover.GRCrossover;
import org.epochx.gr.representation.GRCandidateProgram;
import org.epochx.op.ConfigOperator;
import org.epochx.representation.CandidateProgram;
import org.epochx.stats.AbstractStat;
import org.epochx.stats.Stat;
import org.epochx.stats.Stats;
import org.epochx.tools.grammar.NonTerminalSymbol;
import org.epochx.tools.grammar.Symbol;
import org.epochx.tools.random.RandomNumberGenerator;

public class WhighamCrossover
extends ConfigOperator<GRModel>
implements GRCrossover {
    public static final Stat XO_POINT1 = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){};
    public static final Stat XO_POINT2 = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){};
    public static final Stat XO_SUBTREE1 = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){};
    public static final Stat XO_SUBTREE2 = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){};
    private RandomNumberGenerator rng;

    public WhighamCrossover(RandomNumberGenerator rng) {
        this((GRModel)null);
        this.rng = rng;
    }

    public WhighamCrossover(GRModel model) {
        super(model);
    }

    @Override
    public void onConfigure() {
        this.rng = ((GRModel)this.getModel()).getRNG();
    }

    @Override
    public GRCandidateProgram[] crossover(CandidateProgram p1, CandidateProgram p2) {
        GRCandidateProgram child1 = (GRCandidateProgram)p1;
        GRCandidateProgram child2 = (GRCandidateProgram)p2;
        NonTerminalSymbol parseTree1 = child1.getParseTree();
        NonTerminalSymbol parseTree2 = child2.getParseTree();
        List<NonTerminalSymbol> nonTerminals1 = parseTree1.getNonTerminalSymbols();
        List<NonTerminalSymbol> nonTerminals2 = parseTree2.getNonTerminalSymbols();
        int point1 = this.rng.nextInt(nonTerminals1.size());
        NonTerminalSymbol subtree1 = nonTerminals1.get(point1);
        ArrayList<NonTerminalSymbol> matchingNonTerminals = new ArrayList<NonTerminalSymbol>();
        for (NonTerminalSymbol nt : nonTerminals2) {
            if (!nt.getGrammarRule().equals(subtree1.getGrammarRule())) continue;
            matchingNonTerminals.add(nt);
        }
        if (matchingNonTerminals.isEmpty()) {
            return null;
        }
        int point2 = this.rng.nextInt(matchingNonTerminals.size());
        NonTerminalSymbol subtree2 = (NonTerminalSymbol)matchingNonTerminals.get(point2);
        Stats.get().addData(XO_POINT1, point1);
        Stats.get().addData(XO_POINT2, point2);
        List<Symbol> temp = subtree1.getChildren();
        subtree1.setChildren(subtree2.getChildren());
        subtree2.setChildren(temp);
        Stats.get().addData(XO_SUBTREE1, subtree1);
        Stats.get().addData(XO_SUBTREE2, subtree2);
        return new GRCandidateProgram[]{child1, child2};
    }

    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    public void setRNG(RandomNumberGenerator rng) {
        this.rng = rng;
    }
}

