/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.gr.model.ruby;

import org.apache.commons.lang.ArrayUtils;
import org.epochx.gr.model.GRModel;
import org.epochx.gr.representation.GRCandidateProgram;
import org.epochx.representation.CandidateProgram;
import org.epochx.tools.eval.MalformedProgramException;
import org.epochx.tools.eval.RubyInterpreter;
import org.epochx.tools.grammar.Grammar;
import org.epochx.tools.util.BoolUtils;

public class EvenParity
extends GRModel {
    public static final String GRAMMAR_FRAGMENT = "<prog> ::= <expr>\n<expr> ::= ( <expr> <op> <expr> ) | <var> | <pre-op> ( <var> )\n<pre-op> ::= !\n<op> ::= \"||\" | && | !=\n<var> ::= ";
    private final RubyInterpreter interpreter = new RubyInterpreter();
    private final String[] argNames;
    private final boolean[][] inputValues;

    public EvenParity(int noInputBits) {
        this.inputValues = BoolUtils.generateBoolSequences(noInputBits);
        this.argNames = new String[noInputBits];
        for (int i = 0; i < noInputBits; ++i) {
            this.argNames[i] = "d" + i;
        }
        this.setGrammar(new Grammar(this.getGrammarString()));
    }

    @Override
    public double getFitness(CandidateProgram p) {
        GRCandidateProgram program = (GRCandidateProgram)p;
        double score = 0.0;
        for (boolean[] vars : this.inputValues) {
            Object[] objVars = ArrayUtils.toObject((boolean[])vars);
            Boolean result = null;
            try {
                result = (Boolean)this.interpreter.eval(program.getSourceCode(), this.argNames, objVars);
            }
            catch (MalformedProgramException e) {
                score = 0.0;
                break;
            }
            if (result == null || result.booleanValue() != this.isEvenNoTrue(vars)) continue;
            score += 1.0;
        }
        return (double)this.inputValues.length - score;
    }

    public String getGrammarString() {
        StringBuilder buffer = new StringBuilder(GRAMMAR_FRAGMENT);
        for (int i = 0; i < this.argNames.length; ++i) {
            if (i > 0) {
                buffer.append(" | ");
            }
            buffer.append(this.argNames[i]);
        }
        buffer.append('\n');
        return buffer.toString();
    }

    private boolean isEvenNoTrue(boolean[] input) {
        int noTrues = 0;
        for (boolean b : input) {
            if (!b) continue;
            ++noTrues;
        }
        return noTrues % 2 == 0;
    }
}

