/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.gr.model.java;

import org.epochx.gr.model.GRModel;
import org.epochx.gr.representation.GRCandidateProgram;
import org.epochx.representation.CandidateProgram;
import org.epochx.tools.eval.JavaInterpreter;
import org.epochx.tools.eval.MalformedProgramException;
import org.epochx.tools.grammar.Grammar;

public abstract class Regression
extends GRModel {
    public static final String GRAMMAR_STRING = "<expr> ::= ( <expr> <op> <expr> ) | <terminal>\n<op>   ::= + | - | * \n<terminal>  ::= X \n";
    private static final double POINT_ERROR = 0.01;
    private final JavaInterpreter interpreter;
    private final double[] inputs;
    private final double[] outputs;

    public Regression() {
        this(50);
    }

    public Regression(int noPoints) {
        this.setGrammar(new Grammar(GRAMMAR_STRING));
        this.interpreter = new JavaInterpreter();
        this.inputs = new double[noPoints];
        this.outputs = new double[this.inputs.length];
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputs[i] = this.getRNG().nextDouble() * 2.0 - 1.0;
            this.outputs[i] = this.getCorrectResult(this.inputs[i]);
        }
    }

    @Override
    public double getFitness(CandidateProgram p) {
        GRCandidateProgram program = (GRCandidateProgram)p;
        int noWrong = 0;
        for (int i = 0; i < this.inputs.length; ++i) {
            Double result;
            block4: {
                result = null;
                try {
                    result = (Double)this.interpreter.eval(program.getSourceCode(), new String[]{"X"}, new Double[]{this.inputs[i]});
                }
                catch (MalformedProgramException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
            if (result == null) {
                ++noWrong;
                continue;
            }
            if (!(Math.abs(result - this.outputs[i]) > 0.01)) continue;
            ++noWrong;
        }
        return noWrong;
    }

    public abstract double getCorrectResult(double var1);
}

