/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.gr.model.java;

import org.apache.commons.lang.ArrayUtils;
import org.epochx.gr.model.GRModel;
import org.epochx.gr.representation.GRCandidateProgram;
import org.epochx.representation.CandidateProgram;
import org.epochx.tools.eval.JavaInterpreter;
import org.epochx.tools.eval.MalformedProgramException;
import org.epochx.tools.grammar.Grammar;
import org.epochx.tools.util.BoolUtils;

public class Multiplexer
extends GRModel {
    private static final String GRAMMAR_FRAGMENT = "<prog> ::= <expr>\n<expr> ::= <expr> <op> <expr> | ( <expr> <op> <expr> ) | <var> | <pre-op> ( <var> ) | ( <expr> ) ? <expr> : <expr>\n<pre-op> ::= !\n<op> ::= \"||\" | &&\n<var> ::= ";
    private final JavaInterpreter interpreter = new JavaInterpreter();
    private final boolean[][] inputValues;
    private String[] argNames;
    private int noAddressBits;
    private int noDataBits;

    public Multiplexer(int noInputBits) {
        this.inputValues = BoolUtils.generateBoolSequences(noInputBits);
        this.setBitSizes(noInputBits);
        this.setArgNames(noInputBits);
        this.setGrammar(new Grammar(this.getGrammarString()));
    }

    @Override
    public double getFitness(CandidateProgram p) {
        GRCandidateProgram program = (GRCandidateProgram)p;
        double score = 0.0;
        for (boolean[] vars : this.inputValues) {
            Object[] objVars = ArrayUtils.toObject((boolean[])vars);
            Boolean result = null;
            try {
                result = (Boolean)this.interpreter.eval(program.getSourceCode(), this.argNames, objVars);
            }
            catch (MalformedProgramException e) {
                score = 0.0;
                break;
            }
            if (result == null || result != this.multiplex(vars)) continue;
            score += 1.0;
        }
        return (double)this.inputValues.length - score;
    }

    public String getGrammarString() {
        StringBuilder buffer = new StringBuilder(GRAMMAR_FRAGMENT);
        for (int i = 0; i < this.argNames.length; ++i) {
            if (i > 0) {
                buffer.append(" | ");
            }
            buffer.append(this.argNames[i]);
        }
        buffer.append('\n');
        return buffer.toString();
    }

    private void setBitSizes(int noInputBits) {
        this.noAddressBits = 1;
        while (true) {
            this.noDataBits = (int)Math.pow(2.0, this.noAddressBits);
            if (this.noAddressBits + this.noDataBits == noInputBits) break;
            ++this.noAddressBits;
        }
    }

    private void setArgNames(int noInputBits) {
        int i;
        this.argNames = new String[noInputBits];
        for (i = 0; i < this.noAddressBits; ++i) {
            this.argNames[i] = "a" + i;
        }
        for (i = this.noAddressBits; i < noInputBits; ++i) {
            this.argNames[i] = "d" + i;
        }
    }

    private Boolean multiplex(boolean[] vars) {
        int dataPosition = 0;
        for (int i = 0; i < this.noAddressBits; ++i) {
            if (!vars[i]) continue;
            dataPosition = (int)((double)dataPosition + Math.pow(2.0, i));
        }
        return vars[this.noAddressBits + dataPosition];
    }
}

