/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.gr.model.java;

import org.apache.commons.lang.ArrayUtils;
import org.epochx.gr.model.GRModel;
import org.epochx.gr.representation.GRCandidateProgram;
import org.epochx.representation.CandidateProgram;
import org.epochx.tools.eval.JavaInterpreter;
import org.epochx.tools.eval.MalformedProgramException;
import org.epochx.tools.grammar.Grammar;
import org.epochx.tools.util.BoolUtils;

public class Majority
extends GRModel {
    private static final String GRAMMAR_FRAGMENT = "<prog> ::= <expr>\n<expr> ::= <expr> <op> <expr> | ( <expr> <op> <expr> ) | <var> | <pre-op> ( <var> ) | ( <expr> ) ? <expr> : <expr>\n<pre-op> ::= !\n<op> ::= \"||\" | &&\n<var> ::= ";
    private final JavaInterpreter interpreter = new JavaInterpreter();
    private final String[] argNames;
    private final boolean[][] inputValues;

    public Majority(int noInputBits) {
        this.inputValues = BoolUtils.generateBoolSequences(noInputBits);
        this.argNames = new String[noInputBits];
        for (int i = 0; i < noInputBits; ++i) {
            this.argNames[i] = "d" + i;
        }
        this.setGrammar(new Grammar(this.getGrammarString()));
    }

    @Override
    public double getFitness(CandidateProgram p) {
        GRCandidateProgram program = (GRCandidateProgram)p;
        double score = 0.0;
        for (boolean[] vars : this.inputValues) {
            Object[] objVars = ArrayUtils.toObject((boolean[])vars);
            Boolean result = null;
            try {
                result = (Boolean)this.interpreter.eval(program.getSourceCode(), this.argNames, objVars);
            }
            catch (MalformedProgramException e) {
                score = 0.0;
                break;
            }
            if (result == null || result.booleanValue() != this.majorityTrue(vars)) continue;
            score += 1.0;
        }
        return (double)this.inputValues.length - score;
    }

    public String getGrammarString() {
        StringBuilder buffer = new StringBuilder(GRAMMAR_FRAGMENT);
        for (int i = 0; i < this.argNames.length; ++i) {
            if (i > 0) {
                buffer.append(" | ");
            }
            buffer.append(this.argNames[i]);
        }
        buffer.append('\n');
        return buffer.toString();
    }

    private boolean majorityTrue(boolean[] input) {
        int trueCount = 0;
        for (boolean b : input) {
            if (!b) continue;
            ++trueCount;
        }
        return trueCount >= input.length / 2;
    }
}

