/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.gr.model.java;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.epochx.gr.model.GRModel;
import org.epochx.gr.representation.GRCandidateProgram;
import org.epochx.representation.CandidateProgram;
import org.epochx.tools.ant.Ant;
import org.epochx.tools.ant.AntLandscape;
import org.epochx.tools.eval.JavaInterpreter;
import org.epochx.tools.eval.MalformedProgramException;
import org.epochx.tools.grammar.Grammar;

public abstract class AntTrail
extends GRModel {
    public static final String GRAMMAR_STRING = "<code> ::= <line> | <code> <line>\n<line> ::= <expr>\n<expr> ::= <condition> | <opcode>\n<condition> ::= if(ant.isFoodAhead()){ <opcode> }else{ <opcode> }\n<opcode> ::=  ant.turnLeft(); | ant.turnRight(); | ant.move();\n";
    private final JavaInterpreter interpreter;
    private final AntLandscape landscape;
    private final Ant ant;
    private final List<Point> foodLocations;
    private final int allowedTimeSteps;

    public AntTrail(Point[] foodLocations, Dimension landscapeSize, int allowedTimeSteps) {
        this.foodLocations = new ArrayList<Point>(Arrays.asList(foodLocations));
        this.allowedTimeSteps = allowedTimeSteps;
        this.landscape = new AntLandscape(landscapeSize, null);
        this.ant = new Ant(allowedTimeSteps, this.landscape);
        this.setGrammar(new Grammar(GRAMMAR_STRING));
        this.interpreter = new JavaInterpreter();
    }

    @Override
    public double getFitness(CandidateProgram p) {
        GRCandidateProgram program = (GRCandidateProgram)p;
        this.landscape.setFoodLocations(this.foodLocations);
        this.ant.reset(this.allowedTimeSteps, this.landscape);
        String[] argNames = new String[]{"ant"};
        Object[] argValues = new Object[]{this.ant};
        while (this.ant.getTimesteps() < this.ant.getMaxMoves()) {
            try {
                this.interpreter.exec(program.getSourceCode(), argNames, argValues);
            }
            catch (MalformedProgramException e) {
                break;
            }
        }
        return this.foodLocations.size() - this.ant.getFoodEaten();
    }
}

