/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.gr.model;

import org.epochx.core.Model;
import org.epochx.gr.op.crossover.WhighamCrossover;
import org.epochx.gr.op.init.RampedHalfAndHalfInitialiser;
import org.epochx.gr.op.mutation.WhighamMutation;
import org.epochx.tools.grammar.Grammar;

public abstract class GRModel
extends Model {
    private Grammar grammar = null;
    private int maxDepth = 14;
    private int maxInitialDepth = 8;

    public GRModel() {
        this.setInitialiser(new RampedHalfAndHalfInitialiser(this));
        this.setCrossover(new WhighamCrossover(this));
        this.setMutation(new WhighamMutation(this));
    }

    @Override
    public void run() {
        if (this.getGrammar() == null) {
            throw new IllegalStateException("no grammar set");
        }
        super.run();
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public void setGrammar(Grammar grammar) {
        if (grammar == null) {
            throw new IllegalArgumentException("grammar must not be null");
        }
        this.grammar = grammar;
        assert (this.grammar != null);
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        if (maxDepth < 1 && maxDepth != -1) {
            throw new IllegalArgumentException("maxDepth must either be -1 or greater than 0");
        }
        this.maxDepth = maxDepth;
        assert (this.maxDepth >= 1 || this.maxDepth == -1);
    }

    public int getMaxInitialDepth() {
        return this.maxInitialDepth;
    }

    public void setMaxInitialDepth(int maxInitialDepth) {
        if (maxInitialDepth < 1 && maxInitialDepth != -1) {
            throw new IllegalArgumentException("maxInitialDepth must either be -1 or greater than 0");
        }
        this.maxInitialDepth = maxInitialDepth;
        assert (this.maxInitialDepth >= 1 || this.maxInitialDepth == -1);
    }
}

