/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox.math;

import org.epochx.epox.Node;
import org.epochx.tools.util.NumericUtils;
import org.epochx.tools.util.TypeUtils;

public class SquareFunction
extends Node {
    public SquareFunction() {
        this((Node)null);
    }

    public SquareFunction(Node child) {
        super(child);
    }

    @Override
    public Object evaluate() {
        Object c = this.getChild(0).evaluate();
        double result = Math.pow(NumericUtils.asDouble(c), 2.0);
        if (c instanceof Long) {
            return (long)result;
        }
        if (c instanceof Float) {
            return Float.valueOf((float)result);
        }
        if (c instanceof Integer) {
            return (int)result;
        }
        if (c instanceof Double) {
            return result;
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return "SQUARE";
    }

    @Override
    public Class<?> getReturnType(Class<?> ... inputTypes) {
        if (inputTypes.length == 1 && TypeUtils.isNumericType(inputTypes[0])) {
            return inputTypes[0];
        }
        return null;
    }
}

