/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox.math;

import org.epochx.epox.Node;
import org.epochx.tools.util.NumericUtils;
import org.epochx.tools.util.TypeUtils;

public class SignumFunction
extends Node {
    public SignumFunction() {
        this((Node)null);
    }

    public SignumFunction(Node child) {
        super(child);
    }

    @Override
    public Object evaluate() {
        Object c = this.getChild(0).evaluate();
        double result = Math.signum(NumericUtils.asDouble(c));
        if (c instanceof Double) {
            return result;
        }
        if (c instanceof Float) {
            return Float.valueOf((float)result);
        }
        if (c instanceof Integer) {
            return (int)result;
        }
        if (c instanceof Long) {
            return (long)result;
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return "SGN";
    }

    @Override
    public Class<?> getReturnType(Class<?> ... inputTypes) {
        if (inputTypes.length == 1 && TypeUtils.isNumericType(inputTypes[0])) {
            return inputTypes[0];
        }
        return null;
    }
}

