/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox.math;

import org.epochx.epox.Node;
import org.epochx.tools.util.NumericUtils;
import org.epochx.tools.util.TypeUtils;

public class PowerFunction
extends Node {
    public PowerFunction() {
        this((Node)null, (Node)null);
    }

    public PowerFunction(Node base, Node exponent) {
        super(base, exponent);
    }

    @Override
    public Double evaluate() {
        double c2 = NumericUtils.asDouble(this.getChild(1).evaluate());
        if (c2 == 0.0) {
            return 1.0;
        }
        double c1 = NumericUtils.asDouble(this.getChild(0).evaluate());
        return Math.pow(c1, c2);
    }

    @Override
    public String getIdentifier() {
        return "POW";
    }

    @Override
    public Class<?> getReturnType(Class<?> ... inputTypes) {
        if (inputTypes.length == 2 && TypeUtils.isAllNumericType(inputTypes)) {
            return Double.class;
        }
        return null;
    }
}

