/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox.math;

import org.epochx.epox.Node;
import org.epochx.tools.util.NumericUtils;
import org.epochx.tools.util.TypeUtils;

public class MultiplyFunction
extends Node {
    public MultiplyFunction() {
        this((Node)null, (Node)null);
    }

    public MultiplyFunction(Node child1, Node child2) {
        super(child1, child2);
    }

    @Override
    public Object evaluate() {
        Object c1 = this.getChild(0).evaluate();
        Object c2 = this.getChild(1).evaluate();
        Class<?> returnType = TypeUtils.getNumericType(c1.getClass(), c2.getClass());
        if (returnType == Double.class) {
            double d1 = NumericUtils.asDouble(c1);
            double d2 = NumericUtils.asDouble(c2);
            return d1 * d2;
        }
        if (returnType == Float.class) {
            float f1 = NumericUtils.asFloat(c1).floatValue();
            float f2 = NumericUtils.asFloat(c2).floatValue();
            return Float.valueOf(f1 * f2);
        }
        if (returnType == Long.class) {
            long l1 = NumericUtils.asLong(c1);
            long l2 = NumericUtils.asLong(c2);
            return l1 * l2;
        }
        if (returnType == Integer.class) {
            int i1 = NumericUtils.asInteger(c1);
            int i2 = NumericUtils.asInteger(c2);
            return i1 * i2;
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return "MUL";
    }

    @Override
    public Class<?> getReturnType(Class<?> ... inputTypes) {
        if (inputTypes.length == 2) {
            return TypeUtils.getNumericType(inputTypes);
        }
        return null;
    }
}

