/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox.math;

import org.epochx.epox.Node;
import org.epochx.tools.util.NumericUtils;
import org.epochx.tools.util.TypeUtils;

public class MinFunction
extends Node {
    public MinFunction(int n) {
        this(new Node[]{null});
        this.setChildren(new Node[n]);
    }

    public MinFunction(Node ... children) {
        super(children);
    }

    @Override
    public Object evaluate() {
        int arity = this.getArity();
        Object[] childValues = new Object[arity];
        Class[] types = new Class[arity];
        for (int i = 0; i < arity; ++i) {
            childValues[i] = this.getChild(i).evaluate();
            types[i] = childValues[i].getClass();
        }
        Class<?> returnType = TypeUtils.getNumericType(types);
        if (returnType == Double.class) {
            double min = Double.MAX_VALUE;
            for (int i = 0; i < arity; ++i) {
                double value = NumericUtils.asDouble(childValues[i]);
                min = Math.min(value, min);
            }
            return min;
        }
        if (returnType == Float.class) {
            float min = Float.MAX_VALUE;
            for (int i = 0; i < arity; ++i) {
                float value = NumericUtils.asFloat(childValues[i]).floatValue();
                min = Math.min(value, min);
            }
            return Float.valueOf(min);
        }
        if (returnType == Integer.class) {
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < arity; ++i) {
                int value = NumericUtils.asInteger(childValues[i]);
                min = Math.min(value, min);
            }
            return min;
        }
        if (returnType == Long.class) {
            long min = Long.MAX_VALUE;
            for (int i = 0; i < arity; ++i) {
                long value = NumericUtils.asLong(childValues[i]);
                min = Math.min(value, min);
            }
            return min;
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return "MIN";
    }

    @Override
    public Class<?> getReturnType(Class<?> ... inputTypes) {
        if (inputTypes.length == this.getArity()) {
            return TypeUtils.getNumericType(inputTypes);
        }
        return null;
    }
}

