/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox.math;

import org.epochx.epox.Node;
import org.epochx.tools.util.NumericUtils;
import org.epochx.tools.util.TypeUtils;

public class MaxFunction
extends Node {
    public MaxFunction(int n) {
        this(new Node[]{null});
        this.setChildren(new Node[n]);
    }

    public MaxFunction(Node ... children) {
        super(children);
    }

    @Override
    public Object evaluate() {
        int arity = this.getArity();
        Object[] childValues = new Object[arity];
        Class[] types = new Class[arity];
        for (int i = 0; i < arity; ++i) {
            childValues[i] = this.getChild(i).evaluate();
            types[i] = childValues[i].getClass();
        }
        Class<?> returnType = TypeUtils.getNumericType(types);
        if (returnType == Double.class) {
            double max = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < arity; ++i) {
                double value = NumericUtils.asDouble(childValues[i]);
                max = Math.max(value, max);
            }
            return max;
        }
        if (returnType == Float.class) {
            float max = Float.NEGATIVE_INFINITY;
            for (int i = 0; i < arity; ++i) {
                float value = NumericUtils.asFloat(childValues[i]).floatValue();
                max = Math.max(value, max);
            }
            return Float.valueOf(max);
        }
        if (returnType == Long.class) {
            long max = Long.MIN_VALUE;
            for (int i = 0; i < arity; ++i) {
                long value = NumericUtils.asLong(childValues[i]);
                max = Math.max(value, max);
            }
            return max;
        }
        if (TypeUtils.isNumericType(returnType)) {
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < arity; ++i) {
                int value = NumericUtils.asInteger(childValues[i]);
                max = Math.max(value, max);
            }
            return max;
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return "MAX";
    }

    @Override
    public Class<?> getReturnType(Class<?> ... inputTypes) {
        if (inputTypes.length == this.getArity()) {
            return TypeUtils.getNumericType(inputTypes);
        }
        return null;
    }
}

