/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox.math;

import org.epochx.epox.Node;
import org.epochx.tools.util.NumericUtils;
import org.epochx.tools.util.TypeUtils;

public class InvertProtectedFunction
extends Node {
    private Double protectionValue;

    public InvertProtectedFunction() {
        this((Node)null);
    }

    public InvertProtectedFunction(Node child) {
        this(child, 1.0);
    }

    public InvertProtectedFunction(double protectionValue) {
        this((Node)null);
    }

    public InvertProtectedFunction(Node child, double protectionValue) {
        super(child);
        this.protectionValue = protectionValue;
    }

    @Override
    public Double evaluate() {
        double c = NumericUtils.asDouble(this.getChild(0).evaluate());
        if (c == 0.0) {
            return this.protectionValue;
        }
        return 1.0 / c;
    }

    @Override
    public String getIdentifier() {
        return "INV";
    }

    @Override
    public Class<?> getReturnType(Class<?> ... inputTypes) {
        if (inputTypes.length == 1 && TypeUtils.isNumericType(inputTypes[0])) {
            return Double.class;
        }
        return null;
    }

    public void setProtectionValue(Double protectionValue) {
        this.protectionValue = protectionValue;
    }

    public Double getProtectionValue() {
        return this.protectionValue;
    }
}

