/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox.math;

import org.epochx.epox.Node;
import org.epochx.tools.util.NumericUtils;
import org.epochx.tools.util.TypeUtils;

public class DivisionProtectedFunction
extends Node {
    private Double protectionValue;

    public DivisionProtectedFunction() {
        this((Node)null, (Node)null);
    }

    public DivisionProtectedFunction(double protectionValue) {
        this(null, null, protectionValue);
    }

    public DivisionProtectedFunction(Node dividend, Node divisor) {
        this(dividend, divisor, 0.0);
    }

    public DivisionProtectedFunction(Node dividend, Node divisor, double protectionValue) {
        super(dividend, divisor);
        this.protectionValue = protectionValue;
    }

    @Override
    public Object evaluate() {
        Object c1 = this.getChild(0).evaluate();
        Object c2 = this.getChild(1).evaluate();
        Class<?> returnType = TypeUtils.getNumericType(c1.getClass(), c2.getClass());
        if (returnType == Double.class) {
            double d1 = NumericUtils.asDouble(c1);
            double d2 = NumericUtils.asDouble(c2);
            return d2 == 0.0 ? NumericUtils.asDouble(this.protectionValue) : d1 / d2;
        }
        if (returnType == Float.class) {
            float f1 = NumericUtils.asFloat(c1).floatValue();
            float f2 = NumericUtils.asFloat(c2).floatValue();
            return Float.valueOf(f2 == 0.0f ? NumericUtils.asFloat(this.protectionValue).floatValue() : f1 / f2);
        }
        if (returnType == Long.class) {
            long l1 = NumericUtils.asLong(c1);
            long l2 = NumericUtils.asLong(c2);
            return l2 == 0L ? NumericUtils.asLong(this.protectionValue) : l1 / l2;
        }
        if (returnType == Integer.class) {
            int i1 = NumericUtils.asInteger(c1);
            int i2 = NumericUtils.asInteger(c2);
            return i2 == 0 ? NumericUtils.asInteger(this.protectionValue) : i1 / i2;
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return "PDIV";
    }

    @Override
    public Class<?> getReturnType(Class<?> ... inputTypes) {
        if (inputTypes.length == 2) {
            return TypeUtils.getNumericType(inputTypes);
        }
        return null;
    }

    public void setProtectionValue(Double protectionValue) {
        this.protectionValue = protectionValue;
    }

    public Double getProtectionValue() {
        return this.protectionValue;
    }
}

