/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox.math;

import org.epochx.epox.Node;
import org.epochx.tools.util.NumericUtils;
import org.epochx.tools.util.TypeUtils;

public class CoefficientPowerFunction
extends Node {
    public CoefficientPowerFunction() {
        this((Node)null, (Node)null, (Node)null);
    }

    public CoefficientPowerFunction(Node coefficient, Node term, Node exponent) {
        super(coefficient, term, exponent);
    }

    @Override
    public Double evaluate() {
        Object c1 = this.getChild(0).evaluate();
        Object c2 = this.getChild(1).evaluate();
        Object c3 = this.getChild(2).evaluate();
        Class<?> returnType = TypeUtils.getNumericType(c1.getClass(), c2.getClass(), c3.getClass());
        if (returnType != null) {
            double d1 = NumericUtils.asDouble(this.getChild(0).evaluate());
            double d2 = NumericUtils.asDouble(this.getChild(1).evaluate());
            double d3 = NumericUtils.asDouble(this.getChild(2).evaluate());
            return d1 * Math.pow(d2, d3);
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return "CVP";
    }

    @Override
    public Class<?> getReturnType(Class<?> ... inputTypes) {
        if (inputTypes.length == 3 && TypeUtils.isAllNumericType(inputTypes)) {
            return Double.class;
        }
        return null;
    }
}

