/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox.math;

import org.epochx.epox.Node;
import org.epochx.tools.util.NumericUtils;
import org.epochx.tools.util.TypeUtils;

public class AbsoluteFunction
extends Node {
    public AbsoluteFunction() {
        this((Node)null);
    }

    public AbsoluteFunction(Node child) {
        super(child);
    }

    @Override
    public Object evaluate() {
        Object c = this.getChild(0).evaluate();
        Class<?> returnType = TypeUtils.getNumericType(c.getClass());
        if (returnType == Double.class) {
            return Math.abs(NumericUtils.asDouble(c));
        }
        if (returnType == Float.class) {
            return Float.valueOf(Math.abs(NumericUtils.asFloat(c).floatValue()));
        }
        if (returnType == Long.class) {
            return Math.abs(NumericUtils.asLong(c));
        }
        if (returnType == Integer.class) {
            return Math.abs(NumericUtils.asInteger(c));
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return "ABS";
    }

    @Override
    public Class<?> getReturnType(Class<?> ... inputTypes) {
        if (inputTypes.length == 1) {
            return TypeUtils.getNumericType(inputTypes);
        }
        return null;
    }
}

