/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox;

import org.epochx.epox.Node;

public class Variable
extends Node {
    private final String identifier;
    private Object value;
    private final Class<?> datatype;

    public Variable(String identifier, Class<?> datatype) {
        super(new Node[0]);
        if (identifier == null || datatype == null) {
            throw new IllegalArgumentException("identifier and data-type must be non-null");
        }
        this.identifier = identifier;
        this.datatype = datatype;
    }

    public Variable(String identifier, Object value) {
        super(new Node[0]);
        if (identifier == null || value == null) {
            throw new IllegalArgumentException("identifier and value must be non-null");
        }
        this.identifier = identifier;
        this.value = value;
        this.datatype = value.getClass();
    }

    public void setValue(Object value) {
        if (value != null && !this.datatype.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Variables may not change data-type");
        }
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Object evaluate() {
        return this.value;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public Class<?> getReturnType(Class<?> ... inputTypes) {
        if (inputTypes.length != 0) {
            throw new IllegalArgumentException("variables have no input types");
        }
        return this.datatype;
    }

    @Override
    public String toString() {
        return this.identifier;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public Variable clone() {
        return this;
    }

    @Override
    public Variable newInstance() {
        return this.clone();
    }
}

