/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox;

import java.util.ArrayList;
import java.util.List;
import org.epochx.epox.Literal;
import org.epochx.epox.Node;
import org.epochx.epox.Variable;

public final class NodeUtils {
    private NodeUtils() {
    }

    public static List<Node> getTerminals(List<Node> syntax) {
        if (syntax == null) {
            throw new IllegalArgumentException("syntax must not be null");
        }
        ArrayList<Node> terminals = new ArrayList<Node>(syntax.size());
        for (Node n : syntax) {
            if (!n.isTerminal()) continue;
            terminals.add(n);
        }
        return terminals;
    }

    public static List<Node> getFunctions(List<Node> syntax) {
        if (syntax == null) {
            throw new IllegalArgumentException("syntax must not be null");
        }
        ArrayList<Node> functions = new ArrayList<Node>(syntax.size());
        for (Node n : syntax) {
            if (!n.isFunction()) continue;
            functions.add(n);
        }
        return functions;
    }

    public static List<Literal> intRange(int start, int interval, int quantity) {
        if (quantity < 0) {
            throw new IllegalArgumentException("quantity must be 0 or greater");
        }
        ArrayList<Literal> range = new ArrayList<Literal>(quantity);
        for (int i = 0; i < quantity; ++i) {
            int value = i * interval + start;
            range.add(new Literal(value));
        }
        return range;
    }

    public static List<Literal> longRange(long start, long interval, int quantity) {
        if (quantity < 0) {
            throw new IllegalArgumentException("quantity must be 0 or greater");
        }
        ArrayList<Literal> range = new ArrayList<Literal>(quantity);
        for (int i = 0; i < quantity; ++i) {
            long value = (long)i * interval + start;
            range.add(new Literal(value));
        }
        return range;
    }

    public static List<Literal> doubleRange(double start, double interval, int quantity) {
        if (quantity < 0) {
            throw new IllegalArgumentException("quantity must be 0 or greater");
        }
        ArrayList<Literal> range = new ArrayList<Literal>(quantity);
        for (int i = 0; i < quantity; ++i) {
            double value = (double)i * interval + start;
            range.add(new Literal(value));
        }
        return range;
    }

    public static List<Literal> floatRange(float start, float interval, int quantity) {
        if (quantity < 0) {
            throw new IllegalArgumentException("quantity must be 0 or greater");
        }
        ArrayList<Literal> range = new ArrayList<Literal>(quantity);
        for (int i = 0; i < quantity; ++i) {
            float value = (float)i * interval + start;
            range.add(new Literal(Float.valueOf(value)));
        }
        return range;
    }

    public static List<Variable> createVariables(Class<?> datatype, String ... variableNames) {
        if (variableNames == null) {
            throw new IllegalArgumentException("variableNames must not be null");
        }
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (String name : variableNames) {
            variables.add(new Variable(name, datatype));
        }
        return variables;
    }
}

