/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.epochx.tools.util.TypeUtils;

public abstract class Node
implements Cloneable {
    private Node[] children;

    public Node(Node ... children) {
        this.children = children;
    }

    public abstract Object evaluate();

    public Node[] getChildren() {
        return this.children;
    }

    public void setChildren(Node[] children) {
        this.children = children;
    }

    public Node getChild(int index) {
        return this.children[index];
    }

    public Node getNthNode(int n) {
        if (n >= 0) {
            return this.getNthNode(n, 0);
        }
        throw new IndexOutOfBoundsException("attempt to get node at negative index");
    }

    private Node getNthNode(int n, int current) {
        Node child;
        int childLength;
        if (n == current) {
            return this;
        }
        Node node = null;
        Node[] nodeArray = this.children;
        int n2 = nodeArray.length;
        for (int i = 0; i < n2 && (n > (childLength = (child = nodeArray[i]).getLength()) + current || (node = child.getNthNode(n, current + 1)) == null); ++i) {
            current += childLength;
        }
        if (node == null) {
            throw new IndexOutOfBoundsException("attempt to get node at index >= length");
        }
        return node;
    }

    public void setNthNode(int n, Node newNode) {
        if (n <= 0) {
            if (n == 0) {
                throw new IndexOutOfBoundsException("attempt to set node at index 0, cannot replace self");
            }
            throw new IndexOutOfBoundsException("attempt to set node at negative index");
        }
        this.setNthNode(n, newNode, 0);
    }

    private void setNthNode(int n, Node newNode, int current) {
        int arity = this.getArity();
        for (int i = 0; i < arity; ++i) {
            if (current + 1 == n) {
                this.setChild(i, newNode);
                return;
            }
            Node child = this.getChild(i);
            int childLength = child.getLength();
            if (n <= childLength + current) {
                child.setNthNode(n, newNode, current + 1);
                return;
            }
            current += childLength;
        }
        throw new IndexOutOfBoundsException("attempt to set node at index >= length");
    }

    public int getNthFunctionNodeIndex(int n) {
        int index = this.getNthFunctionNodeIndex(n, 0, 0, this);
        if (index < 0) {
            throw new IndexOutOfBoundsException("attempt to get function node index at index out of range");
        }
        return index;
    }

    private int getNthFunctionNodeIndex(int n, int functionCount, int nodeCount, Node current) {
        if (current.getArity() > 0 && n == functionCount) {
            return nodeCount;
        }
        int result = -1;
        for (Node child : current.children) {
            int childResult;
            int noNodes = child.getLength();
            int noFunctions = child.getNoFunctions();
            if (n <= noFunctions + functionCount && (childResult = this.getNthFunctionNodeIndex(n, functionCount + 1, nodeCount + 1, child)) != -1) {
                return childResult;
            }
            functionCount += noFunctions;
            nodeCount += noNodes;
        }
        return -1;
    }

    public int getNthTerminalNodeIndex(int n) {
        int index = this.getNthTerminalNodeIndex(n, 0, 0, this);
        if (index < 0) {
            throw new IndexOutOfBoundsException("attempt to get terminal node index at index out of range");
        }
        return index;
    }

    private int getNthTerminalNodeIndex(int n, int terminalCount, int nodeCount, Node current) {
        if (current.getArity() == 0 && n == terminalCount++) {
            return nodeCount;
        }
        int result = -1;
        for (Node child : current.getChildren()) {
            int childResult;
            int noNodes = child.getLength();
            int noTerminals = child.getNoTerminals();
            if (n <= noTerminals + terminalCount && (childResult = this.getNthTerminalNodeIndex(n, terminalCount, nodeCount + 1, child)) != -1) {
                return childResult;
            }
            terminalCount += noTerminals;
            nodeCount += noNodes;
        }
        return -1;
    }

    public List<Node> getNodesAtDepth(int depth) {
        ArrayList<Node> nodes = new ArrayList<Node>((depth + 1) * 3);
        if (depth < 0) {
            throw new IndexOutOfBoundsException("attempt to get nodes at negative depth");
        }
        this.getNodesAtDepth(nodes, depth, 0);
        if (nodes.isEmpty()) {
            throw new IndexOutOfBoundsException("attempt to get nodes at depth greater than maximum depth");
        }
        return nodes;
    }

    private void getNodesAtDepth(List<Node> nodes, int d, int current) {
        if (d == current) {
            nodes.add(this);
        } else {
            for (Node child : this.children) {
                child.getNodesAtDepth(nodes, d, current + 1);
            }
        }
    }

    public void setChild(int index, Node child) {
        this.children[index] = child;
    }

    public int getArity() {
        return this.children.length;
    }

    public int getNoTerminals() {
        int arity = this.getArity();
        if (arity == 0) {
            return 1;
        }
        int result = 0;
        for (int i = 0; i < arity; ++i) {
            result += this.getChild(i).getNoTerminals();
        }
        return result;
    }

    public int getNoDistinctTerminals() {
        List<Node> terminals = this.getTerminalNodes();
        HashSet<Node> terminalHash = new HashSet<Node>(terminals);
        return terminalHash.size();
    }

    public List<Node> getTerminalNodes() {
        ArrayList<Node> terminals = new ArrayList<Node>();
        int arity = this.getArity();
        if (arity == 0) {
            terminals.add(this);
        } else {
            for (int i = 0; i < arity; ++i) {
                terminals.addAll(this.getChild(i).getTerminalNodes());
            }
        }
        return terminals;
    }

    public int getNoFunctions() {
        int arity = this.getArity();
        if (arity == 0) {
            return 0;
        }
        int result = 1;
        for (int i = 0; i < arity; ++i) {
            result += this.getChild(i).getNoFunctions();
        }
        return result;
    }

    public int getNoDistinctFunctions() {
        List<Node> functions = this.getFunctionNodes();
        ArrayList<String> functionNames = new ArrayList<String>();
        for (Node f : functions) {
            String name = f.getIdentifier();
            if (functionNames.contains(name)) continue;
            functionNames.add(name);
        }
        return functionNames.size();
    }

    public List<Node> getFunctionNodes() {
        ArrayList<Node> functions = new ArrayList<Node>();
        int arity = this.getArity();
        if (arity > 0) {
            functions.add(this);
            for (int i = 0; i < arity; ++i) {
                functions.addAll(this.getChild(i).getFunctionNodes());
            }
        }
        return functions;
    }

    public int getDepth() {
        return this.countDepth(this, 0, 0);
    }

    private int countDepth(Node rootNode, int currentDepth, int depth) {
        int arity;
        if (currentDepth > depth) {
            depth = currentDepth;
        }
        if ((arity = rootNode.getArity()) > 0) {
            for (int i = 0; i < arity; ++i) {
                Node childNode = rootNode.getChild(i);
                depth = this.countDepth(childNode, currentDepth + 1, depth);
            }
        }
        return depth;
    }

    public int getLength() {
        return this.countLength(this, 0);
    }

    private int countLength(Node rootNode, int length) {
        ++length;
        int arity = rootNode.getArity();
        if (arity > 0) {
            for (int i = 0; i < arity; ++i) {
                Node childNode = rootNode.getChild(i);
                length = this.countLength(childNode, length);
            }
        }
        return length;
    }

    public abstract String getIdentifier();

    public final Class<?> getReturnType() {
        Class[] argTypes = new Class[this.getArity()];
        for (int i = 0; i < this.getArity(); ++i) {
            Node child = this.getChild(i);
            if (child == null) {
                return null;
            }
            argTypes[i] = child.getReturnType();
        }
        return this.getReturnType(argTypes);
    }

    public Class<?> getReturnType(Class<?> ... inputTypes) {
        if (this.getArity() == 0) {
            return Void.class;
        }
        return TypeUtils.getSuper(inputTypes);
    }

    public boolean isFunction() {
        return this.getArity() > 0;
    }

    public boolean isTerminal() {
        return this.getArity() == 0;
    }

    public int hashCode() {
        int result = this.getIdentifier().hashCode();
        for (Node child : this.children) {
            if (child == null) continue;
            result = 37 * result + child.hashCode();
        }
        return result;
    }

    public Node clone() {
        try {
            Node clone = (Node)super.clone();
            clone.children = (Node[])this.children.clone();
            for (int i = 0; i < this.children.length; ++i) {
                clone.children[i] = this.children[i];
                if (clone.children[i] == null) continue;
                clone.children[i] = clone.children[i].clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public Node newInstance() {
        try {
            Node n = (Node)super.clone();
            n.children = new Node[this.children.length];
            return n;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public boolean equals(Object obj) {
        boolean equal = true;
        if (obj instanceof Node) {
            Node n = (Node)obj;
            if (n.getArity() != this.getArity()) {
                equal = false;
            } else if (!this.getIdentifier().equals(n.getIdentifier())) {
                equal = false;
            } else {
                for (int i = 0; i < n.getArity() && equal; ++i) {
                    Node thatChild = n.getChild(i);
                    Node thisChild = this.getChild(i);
                    equal = ObjectUtils.equals((Object)thisChild, (Object)thatChild);
                }
            }
        } else {
            equal = false;
        }
        return equal;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getIdentifier());
        builder.append('(');
        Node[] children = this.getChildren();
        int n = children.length;
        for (int i = 0; i < n; ++i) {
            Node c = children[i];
            if (i != 0) {
                builder.append(' ');
            }
            if (c == null) {
                builder.append('X');
                continue;
            }
            builder.append(c.toString());
        }
        builder.append(')');
        return builder.toString();
    }
}

