/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.epochx.epox.Literal;
import org.epochx.epox.Node;
import org.epochx.epox.Variable;
import org.epochx.epox.ant.AntMoveFunction;
import org.epochx.epox.ant.AntSkipFunction;
import org.epochx.epox.ant.AntTurnLeftFunction;
import org.epochx.epox.ant.AntTurnRightFunction;
import org.epochx.epox.ant.IfFoodAheadFunction;
import org.epochx.epox.bool.AndFunction;
import org.epochx.epox.bool.IfAndOnlyIfFunction;
import org.epochx.epox.bool.ImpliesFunction;
import org.epochx.epox.bool.NandFunction;
import org.epochx.epox.bool.NorFunction;
import org.epochx.epox.bool.NotFunction;
import org.epochx.epox.bool.OrFunction;
import org.epochx.epox.bool.XorFunction;
import org.epochx.epox.lang.IfFunction;
import org.epochx.epox.lang.Seq2Function;
import org.epochx.epox.lang.Seq3Function;
import org.epochx.epox.math.AbsoluteFunction;
import org.epochx.epox.math.AddFunction;
import org.epochx.epox.math.CoefficientPowerFunction;
import org.epochx.epox.math.CubeFunction;
import org.epochx.epox.math.CubeRootFunction;
import org.epochx.epox.math.DivisionProtectedFunction;
import org.epochx.epox.math.ExponentialFunction;
import org.epochx.epox.math.FactorialFunction;
import org.epochx.epox.math.GreaterThanFunction;
import org.epochx.epox.math.InvertProtectedFunction;
import org.epochx.epox.math.LessThanFunction;
import org.epochx.epox.math.Log10Function;
import org.epochx.epox.math.LogFunction;
import org.epochx.epox.math.Max2Function;
import org.epochx.epox.math.Max3Function;
import org.epochx.epox.math.Min2Function;
import org.epochx.epox.math.Min3Function;
import org.epochx.epox.math.ModuloProtectedFunction;
import org.epochx.epox.math.MultiplyFunction;
import org.epochx.epox.math.PowerFunction;
import org.epochx.epox.math.SignumFunction;
import org.epochx.epox.math.SquareFunction;
import org.epochx.epox.math.SquareRootFunction;
import org.epochx.epox.math.SubtractFunction;
import org.epochx.epox.trig.ArcCosecantFunction;
import org.epochx.epox.trig.ArcCosineFunction;
import org.epochx.epox.trig.ArcCotangentFunction;
import org.epochx.epox.trig.ArcSecantFunction;
import org.epochx.epox.trig.ArcSineFunction;
import org.epochx.epox.trig.ArcTangentFunction;
import org.epochx.epox.trig.AreaHyperbolicCosineFunction;
import org.epochx.epox.trig.AreaHyperbolicSineFunction;
import org.epochx.epox.trig.AreaHyperbolicTangentFunction;
import org.epochx.epox.trig.CosecantFunction;
import org.epochx.epox.trig.CosineFunction;
import org.epochx.epox.trig.CotangentFunction;
import org.epochx.epox.trig.HyperbolicCosineFunction;
import org.epochx.epox.trig.HyperbolicSineFunction;
import org.epochx.epox.trig.HyperbolicTangentFunction;
import org.epochx.epox.trig.SecantFunction;
import org.epochx.epox.trig.SineFunction;
import org.epochx.epox.trig.TangentFunction;
import org.epochx.tools.eval.MalformedProgramException;

public class EpoxParser {
    private final Map<String, Class<? extends Node>> functions;
    private final Map<String, Node> functionNodes;
    private final Map<String, Variable> variables = new HashMap<String, Variable>();
    private final Map<String, Object> literalValues;

    public EpoxParser() {
        this.functions = new HashMap<String, Class<? extends Node>>();
        this.functionNodes = new HashMap<String, Node>();
        this.literalValues = new HashMap<String, Object>();
        this.initialiseStandardFunctions();
    }

    private void initialiseStandardFunctions() {
        this.functions.put("AND", AndFunction.class);
        this.functions.put("IFF", IfAndOnlyIfFunction.class);
        this.functions.put("IMPLIES", ImpliesFunction.class);
        this.functions.put("NAND", NandFunction.class);
        this.functions.put("NOR", NorFunction.class);
        this.functions.put("NOT", NotFunction.class);
        this.functions.put("OR", OrFunction.class);
        this.functions.put("XOR", XorFunction.class);
        this.functions.put("ARCCSC", ArcCosecantFunction.class);
        this.functions.put("ARCCOS", ArcCosineFunction.class);
        this.functions.put("ARCCOT", ArcCotangentFunction.class);
        this.functions.put("ARCSEC", ArcSecantFunction.class);
        this.functions.put("ARCSIN", ArcSineFunction.class);
        this.functions.put("ARCTAN", ArcTangentFunction.class);
        this.functions.put("ARCOSH", AreaHyperbolicCosineFunction.class);
        this.functions.put("ARSINH", AreaHyperbolicSineFunction.class);
        this.functions.put("ARTANH", AreaHyperbolicTangentFunction.class);
        this.functions.put("CSC", CosecantFunction.class);
        this.functions.put("COS", CosineFunction.class);
        this.functions.put("COT", CotangentFunction.class);
        this.functions.put("COSH", HyperbolicCosineFunction.class);
        this.functions.put("SINH", HyperbolicSineFunction.class);
        this.functions.put("TANH", HyperbolicTangentFunction.class);
        this.functions.put("SEC", SecantFunction.class);
        this.functions.put("SIN", SineFunction.class);
        this.functions.put("TAN", TangentFunction.class);
        this.functions.put("ABS", AbsoluteFunction.class);
        this.functions.put("ADD", AddFunction.class);
        this.functions.put("CVP", CoefficientPowerFunction.class);
        this.functions.put("CUBE", CubeFunction.class);
        this.functions.put("CBRT", CubeRootFunction.class);
        this.functions.put("EXP", ExponentialFunction.class);
        this.functions.put("FACTORIAL", FactorialFunction.class);
        this.functions.put("GT", GreaterThanFunction.class);
        this.functions.put("INV", InvertProtectedFunction.class);
        this.functions.put("LOG-10", Log10Function.class);
        this.functions.put("LN", LogFunction.class);
        this.functions.put("LT", LessThanFunction.class);
        this.functions.put("MAX", Max2Function.class);
        this.functions.put("MIN", Min2Function.class);
        this.functions.put("MAX3", Max3Function.class);
        this.functions.put("MIN3", Min3Function.class);
        this.functions.put("MOD", ModuloProtectedFunction.class);
        this.functions.put("MUL", MultiplyFunction.class);
        this.functions.put("POW", PowerFunction.class);
        this.functions.put("PDIV", DivisionProtectedFunction.class);
        this.functions.put("SGN", SignumFunction.class);
        this.functions.put("SQUARE", SquareFunction.class);
        this.functions.put("SQRT", SquareRootFunction.class);
        this.functions.put("SUB", SubtractFunction.class);
        this.functions.put("IF-FOOD-AHEAD", IfFoodAheadFunction.class);
        this.functions.put("MOVE", AntMoveFunction.class);
        this.functions.put("TURN-LEFT", AntTurnLeftFunction.class);
        this.functions.put("TURN-RIGHT", AntTurnRightFunction.class);
        this.functions.put("SKIP", AntSkipFunction.class);
        this.functions.put("IF", IfFunction.class);
        this.functions.put("SEQ2", Seq2Function.class);
        this.functions.put("SEQ3", Seq3Function.class);
    }

    public Node parse(String source) throws MalformedProgramException {
        if (source == null) {
            return null;
        }
        int openingBracket = source.indexOf(40);
        String identifier = null;
        List<Object> args = null;
        boolean terminal = false;
        if (openingBracket == -1) {
            identifier = source;
            args = new ArrayList();
            terminal = true;
        } else {
            identifier = source.substring(0, openingBracket).trim();
            int closingBracket = source.lastIndexOf(41);
            String argumentStr = source.substring(openingBracket + 1, closingBracket);
            args = this.splitArguments(argumentStr);
        }
        Node node = terminal ? this.parseTerminal(identifier) : this.initialiseFunction(identifier);
        if (node == null || node.getArity() != args.size()) {
            throw new MalformedProgramException();
        }
        for (int i = 0; i < args.size(); ++i) {
            node.setChild(i, this.parse((String)args.get(i)));
        }
        if (node.getReturnType() == null) {
            if (node.isFunction()) {
                throw new MalformedProgramException("Input data-types for " + node.getIdentifier() + " are invalid");
            }
            throw new MalformedProgramException("Data-type of terminal " + node.getIdentifier() + " is null");
        }
        return node;
    }

    private Node initialiseFunction(String name) throws MalformedProgramException {
        Node node = this.initialiseFunctionNode(name);
        if (node == null) {
            node = this.initialiseFunctionClass(name);
        }
        if (node == null) {
            throw new MalformedProgramException("Unknown function " + name + " encountered");
        }
        return node;
    }

    private Node initialiseFunctionNode(String name) {
        Node node = null;
        Node functionNode = this.functionNodes.get(name);
        if (functionNode != null) {
            node = functionNode.newInstance();
        }
        return node;
    }

    private Node initialiseFunctionClass(String name) throws MalformedProgramException {
        Node node = null;
        Class<? extends Node> functionClass = this.functions.get(name);
        if (functionClass != null) {
            try {
                node = functionClass.newInstance();
            }
            catch (InstantiationException e) {
                assert (false);
                throw new MalformedProgramException("Attempting to use invalid function " + name);
            }
            catch (IllegalAccessException e) {
                assert (false);
                throw new MalformedProgramException("Attempting to use invalid function " + name);
            }
        }
        return node;
    }

    private Node parseTerminal(String terminalStr) {
        Node node = this.variables.get(terminalStr);
        if (node == null) {
            node = this.parseLiteral(terminalStr);
        }
        return node;
    }

    protected Literal parseLiteral(String literalStr) {
        Literal literal = null;
        if (this.literalValues.containsKey(literalStr = literalStr.trim())) {
            literal = new Literal(this.literalValues.get(literalStr));
        } else if (literalStr.equalsIgnoreCase("true") || literalStr.equalsIgnoreCase("false")) {
            literal = new Literal(Boolean.valueOf(literalStr));
        } else if (literalStr.startsWith("\"") && literalStr.endsWith("\"") && literalStr.length() > 1) {
            literal = new Literal(literalStr.substring(1, literalStr.length() - 1));
        } else if (literalStr.startsWith("'") && literalStr.endsWith("'") && literalStr.length() == 3) {
            literal = new Literal(Character.valueOf(literalStr.charAt(1)));
        } else if (literalStr.startsWith("'\\") && literalStr.endsWith("'") && literalStr.length() == 4) {
            literalStr = StringEscapeUtils.unescapeJava((String)literalStr);
            literal = new Literal(Character.valueOf(literalStr.charAt(1)));
        } else {
            literal = this.parseNumericLiteral(literalStr);
        }
        return literal;
    }

    protected Literal parseNumericLiteral(String numericStr) {
        Literal literal = null;
        Number n = NumberFormat.getInstance().parse(numericStr, new ParsePosition(0));
        if (n instanceof Long) {
            long longValue;
            if (numericStr.endsWith("F") || numericStr.endsWith("f")) {
                literal = new Literal(Float.valueOf(n.floatValue()));
            } else if (numericStr.endsWith("D") || numericStr.endsWith("d") || numericStr.contains(".")) {
                literal = new Literal(n.doubleValue());
            } else if (!numericStr.endsWith("L") && !numericStr.endsWith("l") && (longValue = n.longValue()) <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
                literal = new Literal(n.intValue());
            }
        } else if (n instanceof Double && (numericStr.endsWith("F") || numericStr.endsWith("f"))) {
            literal = new Literal(Float.valueOf(n.floatValue()));
        }
        if (literal == null && n != null) {
            literal = new Literal(n);
        }
        return literal;
    }

    public void declareLiteral(String literalStr, Object literalValue) {
        this.literalValues.put(literalStr, literalValue);
    }

    public Object undeclareLiteral(String literalStr) {
        return this.literalValues.remove(literalStr);
    }

    public void declareFunction(String name, Class<? extends Node> functionClass) {
        this.functions.put(name, functionClass);
    }

    public void declareFunction(String name, Node functionNode) {
        this.functionNodes.put(name, functionNode);
    }

    public void undeclareFunction(String name) {
        this.functions.remove(name);
        this.functionNodes.remove(name);
    }

    public void declareVariables(List<Variable> variables) {
        if (variables == null) {
            throw new IllegalArgumentException("variables should be non-null");
        }
        for (Variable v : variables) {
            this.declareVariable(v);
        }
    }

    public void declareVariable(Variable variable) {
        if (variable != null) {
            this.variables.put(variable.getIdentifier(), variable);
        }
    }

    public void undeclareVariable(Variable variable) {
        if (variable != null) {
            this.variables.remove(variable.getIdentifier());
        }
    }

    public void undeclareAllVariables() {
        this.variables.clear();
    }

    private List<String> splitArguments(String argStr) {
        int depth = 0;
        ArrayList<String> args = new ArrayList<String>(5);
        StringBuilder buffer = new StringBuilder();
        argStr = argStr.trim();
        for (int i = 0; i < argStr.length(); ++i) {
            char c = argStr.charAt(i);
            if (c == '(') {
                ++depth;
            } else if (c == ')') {
                --depth;
            }
            if ((c == ' ' || c == ',') && depth == 0) {
                args.add(buffer.toString());
                buffer = new StringBuilder();
                while (argStr.charAt(i + 1) == ' ') {
                    ++i;
                }
                continue;
            }
            buffer.append(c);
        }
        if (buffer.length() > 0) {
            args.add(buffer.toString());
        }
        return args;
    }
}

