/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.epox;

import java.math.BigDecimal;
import java.math.MathContext;
import org.epochx.epox.Literal;
import org.epochx.tools.random.RandomNumberGenerator;

public class DoubleERC
extends Literal {
    private RandomNumberGenerator rng;
    private double lower;
    private double upper;
    private int precision;

    public DoubleERC(RandomNumberGenerator rng, double lower, double upper, int precision) {
        super((Object)null);
        if (rng == null) {
            throw new IllegalArgumentException("random generator must not be null");
        }
        this.rng = rng;
        this.lower = lower;
        this.upper = upper;
        this.precision = precision;
        this.setValue(this.generateValue());
    }

    @Override
    public DoubleERC newInstance() {
        DoubleERC erc = (DoubleERC)super.newInstance();
        erc.setValue(this.generateValue());
        return erc;
    }

    protected double generateValue() {
        if (this.rng == null) {
            throw new IllegalStateException("random number generator must not be null");
        }
        double range = this.upper - this.lower;
        double d = this.rng.nextDouble() * range + this.lower;
        BigDecimal big = new BigDecimal(d);
        big = big.round(new MathContext(this.precision));
        return big.doubleValue();
    }

    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    public void setRNG(RandomNumberGenerator rng) {
        this.rng = rng;
    }

    public double getLower() {
        return this.lower;
    }

    public void setLower(double lower) {
        this.lower = lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public void setUpper(double upper) {
        this.upper = upper;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }
}

