/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import java.util.List;
import org.epochx.core.GenerationManager;
import org.epochx.core.InitialisationManager;
import org.epochx.core.Model;
import org.epochx.life.ConfigListener;
import org.epochx.life.Life;
import org.epochx.representation.CandidateProgram;
import org.epochx.stats.StatField;
import org.epochx.stats.Stats;

public class RunManager
implements ConfigListener {
    private final Model model;
    private final GenerationManager generation;
    private final InitialisationManager initialisation;
    private int noGenerations;
    private double terminationFitness;
    private CandidateProgram bestProgram;
    private double bestFitness;

    public RunManager(Model model) {
        this.model = model;
        this.generation = new GenerationManager(model);
        this.initialisation = new InitialisationManager(model);
        Life.get().addConfigListener(this, false);
    }

    @Override
    public void onConfigure() {
        this.noGenerations = this.model.getNoGenerations();
        this.terminationFitness = this.model.getTerminationFitness();
    }

    public void run(int runNo) {
        Life.get().fireConfigureEvent();
        if (this.noGenerations < -1) {
            throw new IllegalStateException("number of generations must be -1 or greater: " + this.noGenerations);
        }
        Life.get().fireRunStartEvent();
        this.bestProgram = null;
        this.bestFitness = Double.POSITIVE_INFINITY;
        long startTime = System.nanoTime();
        Stats.get().addData(StatField.RUN_NUMBER, runNo);
        List<CandidateProgram> pop = this.initialisation.initialise();
        this.updateBestProgram(pop);
        for (int gen = 1; gen <= this.noGenerations || this.noGenerations == -1; ++gen) {
            pop = this.generation.generation(gen, pop);
            this.updateBestProgram(pop);
            if (!(this.bestFitness <= this.terminationFitness)) continue;
            Life.get().fireSuccessEvent();
            break;
        }
        long runtime = System.nanoTime() - startTime;
        Stats.get().addData(StatField.RUN_TIME, runtime);
        Life.get().fireRunEndEvent();
    }

    private void updateBestProgram(List<CandidateProgram> pop) {
        for (CandidateProgram program : pop) {
            double fitness = program.getFitness();
            if (!(fitness < this.bestFitness)) continue;
            this.bestFitness = fitness;
            this.bestProgram = program;
            Stats.get().addData(StatField.RUN_FITNESS_MIN, this.bestFitness);
            Stats.get().addData(StatField.RUN_FITTEST_PROGRAM, this.bestProgram);
        }
        assert (this.bestProgram != null);
    }

    public GenerationManager getGenerationManager() {
        return this.generation;
    }

    public InitialisationManager getInitialisationManager() {
        return this.initialisation;
    }
}

