/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import org.epochx.core.Model;
import org.epochx.life.ConfigListener;
import org.epochx.life.Life;
import org.epochx.op.ProgramSelector;
import org.epochx.representation.CandidateProgram;
import org.epochx.stats.StatField;
import org.epochx.stats.Stats;

public class ReproductionManager
implements ConfigListener {
    private final Model model;
    private ProgramSelector programSelector;
    private int reversions;

    public ReproductionManager(Model model) {
        this.model = model;
        Life.get().addConfigListener(this, false);
    }

    @Override
    public void onConfigure() {
        this.programSelector = this.model.getProgramSelector();
    }

    public CandidateProgram reproduce() {
        if (this.programSelector == null) {
            throw new IllegalStateException("no program selector set");
        }
        Life.get().fireReproductionStartEvent();
        long startTime = System.nanoTime();
        CandidateProgram parent = null;
        this.reversions = 0;
        do {
            parent = this.programSelector.getProgram();
            parent = Life.get().runReproductionHooks(parent);
            if (parent != null) continue;
            ++this.reversions;
        } while (parent == null);
        long runtime = System.nanoTime() - startTime;
        Stats.get().addData(StatField.REP_REVERSIONS, this.reversions);
        Stats.get().addData(StatField.REP_TIME, runtime);
        Life.get().fireReproductionEndEvent();
        assert (parent != null);
        return parent;
    }
}

