/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import java.util.List;
import org.epochx.core.Model;
import org.epochx.life.ConfigListener;
import org.epochx.life.Life;
import org.epochx.op.PoolSelector;
import org.epochx.representation.CandidateProgram;
import org.epochx.stats.StatField;
import org.epochx.stats.Stats;

public class PoolSelectionManager
implements ConfigListener {
    private final Model model;
    private PoolSelector poolSelector;
    private int poolSize;
    private int reversions;

    public PoolSelectionManager(Model model) {
        this.model = model;
        Life.get().addConfigListener(this, false);
    }

    @Override
    public void onConfigure() {
        this.poolSize = this.model.getPoolSize();
        this.poolSelector = this.model.getPoolSelector();
    }

    public List<CandidateProgram> getPool(List<CandidateProgram> pop) {
        if (this.poolSelector != null && (this.poolSize == 0 || this.poolSize < -1)) {
            throw new IllegalStateException("pool selector set but invalid pool size (=" + this.poolSize + ')');
        }
        Life.get().firePoolSelectionStartEvent();
        long startTime = System.nanoTime();
        this.reversions = 0;
        List<CandidateProgram> pool = null;
        do {
            pool = this.poolSelector == null || this.poolSize == -1 ? pop : this.poolSelector.getPool(pop, this.poolSize);
            pool = Life.get().runPoolSelectionHooks(pool);
            if (pool != null) continue;
            ++this.reversions;
        } while (pool == null);
        long runtime = System.nanoTime() - startTime;
        Stats.get().addData(StatField.POOL_REVERSIONS, this.reversions);
        Stats.get().addData(StatField.POOL_PROGRAMS, pool);
        Stats.get().addData(StatField.POOL_TIME, runtime);
        Life.get().firePoolSelectionEndEvent();
        assert (pool != null);
        return pool;
    }
}

