/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import org.epochx.core.Model;
import org.epochx.life.ConfigListener;
import org.epochx.life.Life;
import org.epochx.op.Mutation;
import org.epochx.op.ProgramSelector;
import org.epochx.representation.CandidateProgram;
import org.epochx.stats.StatField;
import org.epochx.stats.Stats;

public class MutationManager
implements ConfigListener {
    private final Model model;
    private ProgramSelector programSelector;
    private Mutation mutator;
    private int reversions;

    public MutationManager(Model model) {
        this.model = model;
        Life.get().addConfigListener(this, false);
    }

    @Override
    public void onConfigure() {
        this.programSelector = this.model.getProgramSelector();
        this.mutator = this.model.getMutation();
    }

    public CandidateProgram mutate() {
        if (this.mutator == null) {
            throw new IllegalStateException("mutation operator not set");
        }
        if (this.programSelector == null) {
            throw new IllegalStateException("program selector not set");
        }
        Life.get().fireMutationStartEvent();
        long mutationStartTime = System.nanoTime();
        CandidateProgram parent = null;
        CandidateProgram child = null;
        this.reversions = 0;
        do {
            parent = this.programSelector.getProgram();
            child = parent.clone();
            if ((child = this.mutator.mutate(child)) == null || !child.isValid()) {
                child = null;
                continue;
            }
            child = Life.get().runMutationHooks(parent, child);
            if (child != null) continue;
            ++this.reversions;
        } while (child == null);
        long runtime = System.nanoTime() - mutationStartTime;
        Stats.get().addData(StatField.MUT_PARENT, parent);
        Stats.get().addData(StatField.MUT_CHILD, child);
        Stats.get().addData(StatField.MUT_TIME, runtime);
        Stats.get().addData(StatField.MUT_REVERSIONS, this.reversions);
        Life.get().fireMutationEndEvent();
        assert (child != null);
        return child;
    }
}

