/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import org.epochx.core.RunManager;
import org.epochx.life.Life;
import org.epochx.op.Crossover;
import org.epochx.op.Initialiser;
import org.epochx.op.Mutation;
import org.epochx.op.PoolSelector;
import org.epochx.op.ProgramSelector;
import org.epochx.op.selection.TournamentSelector;
import org.epochx.representation.CandidateProgram;
import org.epochx.tools.random.MersenneTwisterFast;
import org.epochx.tools.random.RandomNumberGenerator;

public abstract class Model {
    private RunManager run;
    private PoolSelector poolSelector = null;
    private ProgramSelector programSelector = new TournamentSelector(this, 7);
    private Initialiser initialiser;
    private Crossover crossover;
    private Mutation mutation;
    private RandomNumberGenerator randomNumberGenerator = new MersenneTwisterFast();
    private int noRuns = 1;
    private int noGenerations = 50;
    private int populationSize = 100;
    private int poolSize = 50;
    private int noElites = 10;
    private double terminationFitness = 0.0;
    private double crossoverProbability = 0.9;
    private double mutationProbability = 0.1;
    private double reproductionProbability = 0.0;
    private boolean cacheFitness = true;

    public void run() {
        this.run = new RunManager(this);
        Life.get().fireConfigureEvent();
        if (this.initialiser == null) {
            throw new IllegalStateException("no initialiser set");
        }
        if (this.crossover == null && this.crossoverProbability != 0.0) {
            throw new IllegalStateException("no crossover set");
        }
        if (this.mutation == null && this.mutationProbability != 0.0) {
            throw new IllegalStateException("no mutation set");
        }
        for (int i = 0; i < this.getNoRuns(); ++i) {
            this.run.run(i);
        }
    }

    public RunManager getRunManager() {
        return this.run;
    }

    public abstract double getFitness(CandidateProgram var1);

    public Initialiser getInitialiser() {
        return this.initialiser;
    }

    public void setInitialiser(Initialiser initialiser) {
        if (initialiser == null) {
            throw new IllegalArgumentException("initialiser must not be null");
        }
        this.initialiser = initialiser;
        assert (this.initialiser != null);
    }

    public Crossover getCrossover() {
        return this.crossover;
    }

    public void setCrossover(Crossover crossover) {
        this.crossover = crossover;
    }

    public Mutation getMutation() {
        return this.mutation;
    }

    public void setMutation(Mutation mutation) {
        this.mutation = mutation;
    }

    public boolean cacheFitness() {
        return this.cacheFitness;
    }

    public void setCacheFitness(boolean cacheFitness) {
        this.cacheFitness = cacheFitness;
    }

    public int getNoRuns() {
        return this.noRuns;
    }

    public void setNoRuns(int noRuns) {
        if (noRuns < 0) {
            throw new IllegalArgumentException("noRuns must be zero or more");
        }
        this.noRuns = noRuns;
        assert (this.noRuns >= 0);
    }

    public int getNoGenerations() {
        return this.noGenerations;
    }

    public void setNoGenerations(int noGenerations) {
        if (noGenerations < -1) {
            throw new IllegalArgumentException("noGenerations must be either -1 or greater: " + noGenerations);
        }
        this.noGenerations = noGenerations;
        assert (this.noGenerations >= -1);
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public void setPopulationSize(int populationSize) {
        if (populationSize < 1) {
            throw new IllegalArgumentException("populationSize must be one or more");
        }
        this.populationSize = populationSize;
        assert (this.populationSize >= 1);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        if (poolSize != -1 && poolSize < 1) {
            throw new IllegalArgumentException("poolSize must be one or more");
        }
        this.poolSize = poolSize;
        assert (this.poolSize >= 1);
    }

    public int getNoElites() {
        return this.noElites;
    }

    public void setNoElites(int noElites) {
        if (noElites < 0) {
            throw new IllegalArgumentException("noElites must be zero or more");
        }
        this.noElites = noElites;
        assert (this.noElites >= 1);
    }

    public double getCrossoverProbability() {
        return this.crossoverProbability;
    }

    public void setCrossoverProbability(double crossoverProbability) {
        if (!(crossoverProbability >= 0.0) || !(crossoverProbability <= 1.0)) {
            throw new IllegalArgumentException("crossoverProbability must be between 0.0 and 1.0 inclusive");
        }
        this.crossoverProbability = crossoverProbability;
        assert (this.crossoverProbability >= 0.0 && this.crossoverProbability <= 1.0);
    }

    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public void setMutationProbability(double mutationProbability) {
        if (!(mutationProbability >= 0.0) || !(mutationProbability <= 1.0)) {
            throw new IllegalArgumentException("mutationProbability must be between 0.0 and 1.0 inclusive");
        }
        this.mutationProbability = mutationProbability;
        assert (this.mutationProbability >= 0.0 && this.mutationProbability <= 1.0);
    }

    public double getReproductionProbability() {
        return this.reproductionProbability;
    }

    public void setReproductionProbability(double reproductionProbability) {
        if (!(reproductionProbability >= 0.0) || !(reproductionProbability <= 1.0)) {
            throw new IllegalArgumentException("reproductionProbability must be between 0.0 and 1.0 inclusive");
        }
        this.reproductionProbability = reproductionProbability;
        assert (this.reproductionProbability >= 0.0 && this.reproductionProbability <= 1.0);
    }

    public double getTerminationFitness() {
        return this.terminationFitness;
    }

    public void setTerminationFitness(double terminationFitness) {
        this.terminationFitness = terminationFitness;
    }

    public ProgramSelector getProgramSelector() {
        return this.programSelector;
    }

    public void setProgramSelector(ProgramSelector programSelector) {
        if (programSelector == null) {
            throw new IllegalArgumentException("program selector must not be null");
        }
        this.programSelector = programSelector;
        assert (this.programSelector != null);
    }

    public PoolSelector getPoolSelector() {
        return this.poolSelector;
    }

    public void setPoolSelector(PoolSelector poolSelector) {
        this.poolSelector = poolSelector;
    }

    public RandomNumberGenerator getRNG() {
        return this.randomNumberGenerator;
    }

    public void setRNG(RandomNumberGenerator rng) {
        if (rng == null) {
            throw new IllegalArgumentException("random number generator must not be null");
        }
        this.randomNumberGenerator = rng;
        assert (this.randomNumberGenerator != null);
    }
}

