/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import java.util.List;
import org.epochx.core.Model;
import org.epochx.life.ConfigListener;
import org.epochx.life.Life;
import org.epochx.op.Initialiser;
import org.epochx.representation.CandidateProgram;
import org.epochx.stats.StatField;
import org.epochx.stats.Stats;

public class InitialisationManager
implements ConfigListener {
    private final Model model;
    private Initialiser initialiser;
    private int reversions;

    public InitialisationManager(Model model) {
        this.model = model;
        Life.get().addConfigListener(this, false);
    }

    @Override
    public void onConfigure() {
        this.initialiser = this.model.getInitialiser();
    }

    public List<CandidateProgram> initialise() {
        Life.get().fireConfigureEvent();
        if (this.initialiser == null) {
            throw new IllegalStateException("no initialiser set");
        }
        Life.get().fireGenerationStartEvent();
        Life.get().fireInitialisationStartEvent();
        long startTime = System.nanoTime();
        Stats.get().addData(StatField.GEN_NUMBER, 0);
        this.reversions = 0;
        List<CandidateProgram> pop = null;
        do {
            pop = this.initialiser.getInitialPopulation();
            pop = Life.get().runGenerationHooks(pop);
            pop = Life.get().runInitialisationHooks(pop);
            if (pop != null) continue;
            ++this.reversions;
        } while (pop == null);
        Stats.get().addData(StatField.INIT_REVERSIONS, this.reversions);
        Stats.get().addData(StatField.GEN_POP, pop);
        Stats.get().addData(StatField.GEN_TIME, System.nanoTime() - startTime);
        Life.get().fireInitialisationEndEvent();
        Life.get().fireGenerationEndEvent();
        return pop;
    }
}

