/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import java.util.ArrayList;
import java.util.List;
import org.epochx.core.CrossoverManager;
import org.epochx.core.ElitismManager;
import org.epochx.core.Model;
import org.epochx.core.MutationManager;
import org.epochx.core.PoolSelectionManager;
import org.epochx.core.ReproductionManager;
import org.epochx.life.ConfigListener;
import org.epochx.life.Life;
import org.epochx.op.ProgramSelector;
import org.epochx.representation.CandidateProgram;
import org.epochx.stats.StatField;
import org.epochx.stats.Stats;
import org.epochx.tools.random.RandomNumberGenerator;

public class GenerationManager
implements ConfigListener {
    private final Model model;
    private final ElitismManager elitism;
    private final PoolSelectionManager poolSelection;
    private final CrossoverManager crossover;
    private final MutationManager mutation;
    private final ReproductionManager reproduction;
    private ProgramSelector programSelector;
    private RandomNumberGenerator rng;
    private int popSize;
    private double mutationProbability;
    private double crossoverProbability;
    private int reversions;

    public GenerationManager(Model model) {
        this.model = model;
        this.elitism = new ElitismManager(model);
        this.poolSelection = new PoolSelectionManager(model);
        this.crossover = new CrossoverManager(model);
        this.mutation = new MutationManager(model);
        this.reproduction = new ReproductionManager(model);
        this.reversions = 0;
        Life.get().addConfigListener(this, false);
    }

    @Override
    public void onConfigure() {
        this.rng = this.model.getRNG();
        this.programSelector = this.model.getProgramSelector();
        this.popSize = this.model.getPopulationSize();
        this.mutationProbability = this.model.getMutationProbability();
        this.crossoverProbability = this.model.getCrossoverProbability();
    }

    public List<CandidateProgram> generation(int generationNo, List<CandidateProgram> previousPop) {
        List<CandidateProgram> pop;
        if (previousPop == null || previousPop.size() < 1) {
            throw new IllegalArgumentException("previousPop must not be null and size must be 1 or greater.");
        }
        if (this.rng == null) {
            throw new IllegalStateException("no random number generator set");
        }
        if (this.programSelector == null) {
            throw new IllegalStateException("no program selector set");
        }
        if (this.popSize < 1) {
            throw new IllegalStateException("pop size should be 1 or greater");
        }
        if (this.crossoverProbability < 0.0 || this.crossoverProbability > 1.0) {
            throw new IllegalStateException("crossover probability should be between 0.0 and 1.0");
        }
        if (this.mutationProbability < 0.0 || this.mutationProbability > 1.0) {
            throw new IllegalStateException("mutation probability should be between 0.0 and 1.0");
        }
        Life.get().fireGenerationStartEvent();
        this.reversions = 0;
        long startTime = System.nanoTime();
        Stats.get().addData(StatField.GEN_NUMBER, generationNo);
        do {
            pop = new ArrayList<CandidateProgram>(this.popSize);
            pop.addAll(this.elitism.elitism(previousPop));
            List<CandidateProgram> pool = this.poolSelection.getPool(previousPop);
            this.programSelector.setSelectionPool(pool);
            while (pop.size() < this.popSize) {
                double random = this.rng.nextDouble();
                if (random < this.crossoverProbability) {
                    CandidateProgram[] children;
                    for (CandidateProgram c : children = this.crossover.crossover()) {
                        if (pop.size() >= this.popSize) continue;
                        pop.add(c);
                    }
                    continue;
                }
                if (random < this.crossoverProbability + this.mutationProbability) {
                    pop.add(this.mutation.mutate());
                    continue;
                }
                pop.add(this.reproduction.reproduce());
            }
            pop = Life.get().runGenerationHooks(pop);
            if (pop != null) continue;
            ++this.reversions;
        } while (pop == null);
        Stats.get().addData(StatField.GEN_REVERSIONS, this.reversions);
        Stats.get().addData(StatField.GEN_POP, pop);
        Stats.get().addData(StatField.GEN_TIME, System.nanoTime() - startTime);
        Life.get().fireGenerationEndEvent();
        assert (pop != null);
        return pop;
    }

    public ElitismManager getElitismManager() {
        return this.elitism;
    }

    public PoolSelectionManager getPoolSelectionManager() {
        return this.poolSelection;
    }

    public CrossoverManager getCrossoverManager() {
        return this.crossover;
    }

    public MutationManager getMutationManager() {
        return this.mutation;
    }

    public ReproductionManager getReproductionManager() {
        return this.reproduction;
    }
}

