/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.epochx.core.Model;
import org.epochx.life.ConfigListener;
import org.epochx.life.Life;
import org.epochx.representation.CandidateProgram;
import org.epochx.stats.StatField;
import org.epochx.stats.Stats;

public class ElitismManager
implements ConfigListener {
    private final Model model;
    private int noElites;

    public ElitismManager(Model model) {
        this.model = model;
        Life.get().addConfigListener(this, false);
    }

    @Override
    public void onConfigure() {
        this.noElites = this.model.getNoElites();
        int popSize = this.model.getPopulationSize();
        int n = this.noElites = this.noElites < popSize ? this.noElites : popSize;
        assert (this.noElites <= popSize);
    }

    public List<CandidateProgram> elitism(List<CandidateProgram> pop) {
        ArrayList<CandidateProgram> elites;
        if (pop == null) {
            throw new IllegalArgumentException("pop size must not be null");
        }
        if (this.noElites < 0) {
            throw new IllegalStateException("no elites is less than 0");
        }
        Life.get().fireElitismStartEvent();
        long startTime = System.nanoTime();
        if (this.noElites > 0) {
            Collections.sort(pop);
            elites = new ArrayList<CandidateProgram>(pop.subList(pop.size() - this.noElites, pop.size()));
        } else {
            elites = new ArrayList();
        }
        assert (elites.size() == this.noElites);
        long runtime = System.nanoTime() - startTime;
        Stats.get().addData(StatField.ELITE_PROGRAMS, elites);
        Stats.get().addData(StatField.ELITE_TIME, runtime);
        elites = Life.get().runElitismHooks(elites);
        Life.get().fireElitismEndEvent();
        return elites;
    }
}

