/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import org.epochx.core.Model;
import org.epochx.life.ConfigListener;
import org.epochx.life.Life;
import org.epochx.op.Crossover;
import org.epochx.op.ProgramSelector;
import org.epochx.representation.CandidateProgram;
import org.epochx.stats.StatField;
import org.epochx.stats.Stats;

public class CrossoverManager
implements ConfigListener {
    private final Model model;
    private ProgramSelector programSelector;
    private Crossover crossover;
    private int reversions;

    public CrossoverManager(Model model) {
        this.model = model;
        Life.get().addConfigListener(this, false);
    }

    @Override
    public void onConfigure() {
        this.programSelector = this.model.getProgramSelector();
        this.crossover = this.model.getCrossover();
    }

    public CandidateProgram[] crossover() {
        if (this.crossover == null) {
            throw new IllegalStateException("crossover operator not set");
        }
        if (this.programSelector == null) {
            throw new IllegalStateException("program selector not set");
        }
        Life.get().fireCrossoverStartEvent();
        long crossoverStartTime = System.nanoTime();
        CandidateProgram[] parents = null;
        CandidateProgram[] children = null;
        this.reversions = 0;
        do {
            CandidateProgram parent1 = this.programSelector.getProgram();
            CandidateProgram parent2 = this.programSelector.getProgram();
            CandidateProgram clone1 = parent1.clone();
            CandidateProgram clone2 = parent2.clone();
            parents = new CandidateProgram[]{parent1, parent2};
            children = this.crossover.crossover(clone1, clone2);
            if (children == null || !this.allValid(children)) {
                children = null;
                continue;
            }
            children = Life.get().runCrossoverHooks(parents, children);
            if (children != null) continue;
            ++this.reversions;
        } while (children == null);
        long runtime = System.nanoTime() - crossoverStartTime;
        Stats.get().addData(StatField.XO_PARENTS, parents);
        Stats.get().addData(StatField.XO_CHILDREN, children);
        Stats.get().addData(StatField.XO_REVERSIONS, this.reversions);
        Stats.get().addData(StatField.XO_TIME, runtime);
        Life.get().fireCrossoverEndEvent();
        assert (children != null);
        return children;
    }

    private boolean allValid(CandidateProgram[] programs) {
        assert (programs != null);
        boolean valid = true;
        for (CandidateProgram p : programs) {
            if (p.isValid()) continue;
            valid = false;
            break;
        }
        return valid;
    }
}

