/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner.validation;

import com.github.mvp4g.mvp4g2.core.ui.AbstractPresenter;
import com.github.mvp4g.mvp4g2.core.ui.IsShell;
import com.github.mvp4g.mvp4g2.core.ui.IsViewCreator;
import com.github.mvp4g.mvp4g2.core.ui.annotation.Presenter;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.intern.ClassNameModel;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class PresenterAnnotationValidator {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;

    private PresenterAnnotationValidator() {
    }

    private PresenterAnnotationValidator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate(Element element, TypeElement viewClassTypeElement, TypeElement viewInterfaceTypeElement) throws ProcessorException {
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            if (!typeElement.getKind().isClass()) {
                throw new ProcessorException("Mvp4g2Processor:" + typeElement.getSimpleName().toString() + ": @Presenter can only be used with a class!");
            }
            if (!viewClassTypeElement.getKind().isClass()) {
                throw new ProcessorException("Mvp4g2Processor:" + typeElement.getSimpleName().toString() + ": the viewClass-attribute of a @Presenter must be a class!");
            }
            if (!viewInterfaceTypeElement.getKind().isInterface()) {
                throw new ProcessorException("Mvp4g2Processor:" + typeElement.getSimpleName().toString() + ": the viewInterface-attribute of a @Presenter must be a interface!");
            }
            if (!this.processorUtils.implementsInterface(this.processingEnvironment, viewClassTypeElement, viewInterfaceTypeElement.asType())) {
                throw new ProcessorException("Mvp4g2Processor:" + typeElement.getSimpleName().toString() + ": the viewClass-attribute of a @Presenter must implement the viewInterface!");
            }
            if (!this.processorUtils.extendsClassOrInterface(this.processingEnvironment.getTypeUtils(), typeElement.asType(), this.processingEnvironment.getElementUtils().getTypeElement(AbstractPresenter.class.getCanonicalName()).asType())) {
                throw new ProcessorException(typeElement.getSimpleName().toString() + ": @Presenter must extend AbstractPresenter.class!");
            }
            if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                throw new ProcessorException("Mvp4g2Processor:" + typeElement.getSimpleName().toString() + ": @Presenter can not be ABSTRACT");
            }
            if (viewClassTypeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                throw new ProcessorException(typeElement.getSimpleName().toString() + ": class-attribute of @Presenter can not be ABSTRACT");
            }
            TypeMirror isShellMirror = this.processorUtils.getFlattenedSupertype(this.processingEnvironment.getTypeUtils(), typeElement.asType(), this.processingEnvironment.getElementUtils().getTypeElement(IsShell.class.getCanonicalName()).asType());
            if (isShellMirror != null && typeElement.getAnnotation(Presenter.class).multiple()) {
                throw new ProcessorException(typeElement.getSimpleName().toString() + ": IsShell interface can not be used on a presenter which is defiend as multiple = true");
            }
            Presenter presenterAnnotation = typeElement.getAnnotation(Presenter.class);
            if (Presenter.VIEW_CREATION_METHOD.PRESENTER.equals((Object)presenterAnnotation.viewCreator())) {
                if (!this.processorUtils.extendsClassOrInterface(this.processingEnvironment.getTypeUtils(), typeElement.asType(), this.processingEnvironment.getElementUtils().getTypeElement(IsViewCreator.class.getCanonicalName()).asType())) {
                    throw new ProcessorException(typeElement.getSimpleName().toString() + ": @Presenter must implement the IsViewCreator interface");
                }
                if (!this.processorUtils.supertypeHasGeneric(this.processingEnvironment.getTypeUtils(), typeElement.asType(), this.processingEnvironment.getElementUtils().getTypeElement(IsViewCreator.class.getCanonicalName()).asType())) {
                    throw new ProcessorException(typeElement.getSimpleName().toString() + ": IsViewCreator interface needs a generic parameter (add: >>" + viewInterfaceTypeElement.toString() + "<< as generic to IsViewCreator)");
                }
                TypeMirror isViewCreatorTypeMirror = this.processorUtils.getFlattenedSupertype(this.processingEnvironment.getTypeUtils(), typeElement.asType(), this.processingEnvironment.getElementUtils().getTypeElement(IsViewCreator.class.getCanonicalName()).asType());
                ClassNameModel classNameModel = new ClassNameModel(viewInterfaceTypeElement.toString());
                if (!isViewCreatorTypeMirror.toString().contains(classNameModel.getSimpleName())) {
                    throw new ProcessorException(typeElement.getSimpleName().toString() + ": IsViewCreator interface only allows the generic parameter -> " + viewInterfaceTypeElement.toString());
                }
            } else if (Presenter.VIEW_CREATION_METHOD.FRAMEWORK.equals((Object)presenterAnnotation.viewCreator()) && this.processorUtils.extendsClassOrInterface(this.processingEnvironment.getTypeUtils(), typeElement.asType(), this.processingEnvironment.getElementUtils().getTypeElement(IsViewCreator.class.getCanonicalName()).asType())) {
                throw new ProcessorException(typeElement.getSimpleName().toString() + ": the IsViewCreator interface can only be used in case of viewCreator = Presenter.VIEW_CREATION_METHOD.PRESENTER");
            }
        } else {
            throw new ProcessorException("Mvp4g2Processor: @Presenter can only be used on a type (class)");
        }
    }

    public static final class Builder {
        ProcessingEnvironment processingEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public PresenterAnnotationValidator build() {
            return new PresenterAnnotationValidator(this);
        }
    }
}

