/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner;

import com.github.mvp4g.mvp4g2.core.ui.IsShell;
import com.github.mvp4g.mvp4g2.core.ui.annotation.Presenter;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.PresenterMetaModel;
import com.github.mvp4g.mvp4g2.processor.scanner.validation.PresenterAnnotationValidator;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class PresenterAnnotationScanner {
    private static final String PRESENTER_PROPERTIES = "presenter.properties";
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;

    private PresenterAnnotationScanner(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public PresenterMetaModel scan(RoundEnvironment roundEnvironment) throws ProcessorException {
        PresenterAnnotationValidator validator = PresenterAnnotationValidator.builder().processingEnvironment(this.processingEnvironment).build();
        PresenterMetaModel model = this.restore();
        for (Element element : roundEnvironment.getElementsAnnotatedWith(Presenter.class)) {
            TypeElement typeElement = (TypeElement)element;
            validator.validate(typeElement, this.getViewClassTypeElement(typeElement.getAnnotation(Presenter.class)), this.getViewInterfaceTypeElement(typeElement.getAnnotation(Presenter.class)));
            model.add(((TypeElement)element).getQualifiedName().toString(), typeElement.getAnnotation(Presenter.class).multiple() ? "true" : "false", this.processorUtils.extendsClassOrInterface(this.processingEnvironment.getTypeUtils(), typeElement.asType(), this.processingEnvironment.getElementUtils().getTypeElement(IsShell.class.getCanonicalName()).asType()) ? "true" : "false", this.getViewClassTypeElement(element.getAnnotation(Presenter.class)).getQualifiedName().toString(), this.getViewInterfaceTypeElement(element.getAnnotation(Presenter.class)).getQualifiedName().toString(), typeElement.getAnnotation(Presenter.class).viewCreator().toString(), this.processorUtils.createHandledEventArray(typeElement));
        }
        this.processorUtils.store(model, this.createRelativeFileName());
        return model;
    }

    private PresenterMetaModel restore() {
        Properties props = new Properties();
        try {
            FileObject resource = this.processingEnvironment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.createRelativeFileName());
            props.load(resource.openInputStream());
            return new PresenterMetaModel(props);
        }
        catch (IOException iOException) {
            return new PresenterMetaModel();
        }
    }

    private TypeElement getViewClassTypeElement(Presenter presenterAnnotation) {
        try {
            presenterAnnotation.viewClass();
        }
        catch (MirroredTypeException exception) {
            return (TypeElement)this.processingEnvironment.getTypeUtils().asElement(exception.getTypeMirror());
        }
        return null;
    }

    private TypeElement getViewInterfaceTypeElement(Presenter presenterAnnotation) {
        try {
            presenterAnnotation.viewInterface();
        }
        catch (MirroredTypeException exception) {
            return (TypeElement)this.processingEnvironment.getTypeUtils().asElement(exception.getTypeMirror());
        }
        return null;
    }

    private String createRelativeFileName() {
        return "META-INF/mvp4g2/presenter.properties";
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public PresenterAnnotationScanner build() {
            return new PresenterAnnotationScanner(this);
        }
    }
}

