/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner;

import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Filters;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.EventBusMetaModel;
import com.github.mvp4g.mvp4g2.processor.scanner.validation.FilterAnnotationValidator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class FiltersAnnotationScanner {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private TypeElement eventBusTypeElement;
    private EventBusMetaModel eventBusMetaModel;

    private FiltersAnnotationScanner(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.eventBusTypeElement = builder.eventBusTypeElement;
        this.eventBusMetaModel = builder.eventBusMetaModel;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public EventBusMetaModel scan(RoundEnvironment roundEnvironment) throws ProcessorException {
        FilterAnnotationValidator.builder().roundEnvironment(roundEnvironment).processingEnvironment(this.processingEnvironment).eventBusTypeElement(this.eventBusTypeElement).build().validate();
        Filters filtersAnnotation = this.eventBusTypeElement.getAnnotation(Filters.class);
        if (Objects.isNull(filtersAnnotation)) {
            this.eventBusMetaModel.setHasFiltersAnnotation("false");
        } else {
            this.eventBusMetaModel.setHasFiltersAnnotation("true");
            this.eventBusMetaModel.setFilters(this.getEventFiltersAsList(this.eventBusTypeElement));
        }
        return this.eventBusMetaModel;
    }

    public List<String> getEventFiltersAsList(TypeElement typeElement) {
        TypeElement filterAnnotation = this.processingEnvironment.getElementUtils().getTypeElement(Filters.class.getName());
        TypeMirror filterAnnotationAsTypeMirror = filterAnnotation.asType();
        return typeElement.getAnnotationMirrors().stream().filter(annotationMirror -> annotationMirror.getAnnotationType().equals(filterAnnotationAsTypeMirror)).flatMap(annotationMirror -> annotationMirror.getElementValues().entrySet().stream()).findFirst().map(entry -> Arrays.stream(((AnnotationValue)entry.getValue()).toString().replace("{", "").replace("}", "").replace(" ", "").split(",")).map(v -> v.substring(0, v.indexOf(".class"))).collect(Collectors.toList())).orElse(null);
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;
        TypeElement eventBusTypeElement;
        EventBusMetaModel eventBusMetaModel;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public Builder eventBusTypeElement(TypeElement eventBusTypeElement) {
            this.eventBusTypeElement = eventBusTypeElement;
            return this;
        }

        public Builder eventBusMetaModel(EventBusMetaModel eventBusMetaModel) {
            this.eventBusMetaModel = eventBusMetaModel;
            return this;
        }

        public FiltersAnnotationScanner build() {
            return new FiltersAnnotationScanner(this);
        }
    }
}

