/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.validators.mpm;

import br.com.fluentvalidator.AbstractValidator;
import br.com.fluentvalidator.Validator;
import br.com.fluentvalidator.builder.WheneverCollection;
import br.com.fluentvalidator.function.FunctionBuilder;
import br.com.fluentvalidator.predicate.ComparablePredicate;
import br.com.fluentvalidator.predicate.LogicalPredicate;
import br.com.fluentvalidator.predicate.ObjectPredicate;
import br.com.fluentvalidator.predicate.StringPredicate;
import com.emv.qrcode.core.model.mpm.TagLengthString;
import com.emv.qrcode.model.mpm.AdditionalDataField;
import com.emv.qrcode.validators.mpm.PaymentSystemSpecificTemplateValidator;
import com.emv.qrcode.validators.mpm.TagLengthStringValidator;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

class AdditionalDataFieldValidator
extends AbstractValidator<AdditionalDataField> {
    AdditionalDataFieldValidator() {
    }

    public void rules() {
        this.ruleFor(AdditionalDataField::getBillNumber).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("BillNumber tag is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getBillNumber).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("BillNumber tag must be size equal two").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getBillNumber).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("BillNumber tag must be number").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getBillNumber).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"01")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("BillNumber tag must be '%s'", "01")).withAttempedValue(FunctionBuilder.of(AdditionalDataField::getBillNumber).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("BillNumber value is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getBillNumber).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)25)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("BillNumber value must less then or equal size twenty-five").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getBillNumber).andThen(TagLengthString::getValue)).critical();
        this.ruleFor(AdditionalDataField::getMobileNumber).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("MobileNumber tag is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getMobileNumber).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("MobileNumber tag must be size equal two").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getMobileNumber).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("MobileNumber tag must be number").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getMobileNumber).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"02")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("MobileNumber tag must be '%s'", "02")).withAttempedValue(FunctionBuilder.of(AdditionalDataField::getMobileNumber).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("MobileNumber value is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getMobileNumber).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)25)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("MobileNumber value must less then or equal size twenty-five").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getMobileNumber).andThen(TagLengthString::getValue)).critical();
        this.ruleFor(AdditionalDataField::getStoreLabel).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("StoreLabel tag is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getStoreLabel).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("StoreLabel tag must be size equal two").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getStoreLabel).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("StoreLabel tag must be number").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getStoreLabel).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"03")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("StoreLabel tag must be '%s'", "03")).withAttempedValue(FunctionBuilder.of(AdditionalDataField::getStoreLabel).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("StoreLabel value is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getStoreLabel).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)25)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("StoreLabel value must less then or equal size twenty-five").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getStoreLabel).andThen(TagLengthString::getValue)).critical();
        this.ruleFor(AdditionalDataField::getLoyaltyNumber).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("LoyaltyNumber tag is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getLoyaltyNumber).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("LoyaltyNumber tag must be size equal two").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getLoyaltyNumber).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("LoyaltyNumber tag must be number").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getLoyaltyNumber).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"04")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("LoyaltyNumber tag must be '%s'", "04")).withAttempedValue(FunctionBuilder.of(AdditionalDataField::getLoyaltyNumber).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("LoyaltyNumber value is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getLoyaltyNumber).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)25)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("LoyaltyNumber value must less then or equal size twenty-five").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getLoyaltyNumber).andThen(TagLengthString::getValue)).critical();
        this.ruleFor(AdditionalDataField::getReferenceLabel).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ReferenceLabel tag is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getReferenceLabel).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ReferenceLabel tag must be size equal two").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getReferenceLabel).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ReferenceLabel tag must be number").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getReferenceLabel).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"05")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("ReferenceLabel tag must be '%s'", "05")).withAttempedValue(FunctionBuilder.of(AdditionalDataField::getReferenceLabel).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ReferenceLabel value is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getReferenceLabel).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)25)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("ReferenceLabel value must less then or equal size twenty-five").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getReferenceLabel).andThen(TagLengthString::getValue)).critical();
        this.ruleFor(AdditionalDataField::getCustomerLabel).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("CustomerLabel tag is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getCustomerLabel).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("CustomerLabel tag must be size equal two").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getCustomerLabel).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("CustomerLabel tag must be number").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getCustomerLabel).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"06")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("CustomerLabel tag must be '%s'", "06")).withAttempedValue(FunctionBuilder.of(AdditionalDataField::getCustomerLabel).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("CustomerLabel value is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getCustomerLabel).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)25)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("CustomerLabel value must less then or equal size twenty-five").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getCustomerLabel).andThen(TagLengthString::getValue)).critical();
        this.ruleFor(AdditionalDataField::getTerminalLabel).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TerminalLabel tag is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getTerminalLabel).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TerminalLabel tag must be size equal two").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getTerminalLabel).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TerminalLabel tag must be number").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getTerminalLabel).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"07")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("TerminalLabel tag must be '%s'", "07")).withAttempedValue(FunctionBuilder.of(AdditionalDataField::getTerminalLabel).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TerminalLabel value is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getTerminalLabel).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)25)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TerminalLabel value must less then or equal size twenty-five").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getTerminalLabel).andThen(TagLengthString::getValue)).critical();
        this.ruleFor(AdditionalDataField::getPurposeTransaction).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TerminalLabel tag is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getPurposeTransaction).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TerminalLabel tag must be size equal two").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getPurposeTransaction).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TerminalLabel tag must be number").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getPurposeTransaction).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"08")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("TerminalLabel tag must be '%s'", "08")).withAttempedValue(FunctionBuilder.of(AdditionalDataField::getPurposeTransaction).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TerminalLabel value is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getPurposeTransaction).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)25)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("TerminalLabel value must less then or equal size twenty-five").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getPurposeTransaction).andThen(TagLengthString::getValue)).critical();
        this.ruleFor(AdditionalDataField::getAdditionalConsumerDataRequest).must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getTag))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("AdditionalConsumerDataRequest tag is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getAdditionalConsumerDataRequest).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringSize(TagLengthString::getTag, (Integer)2)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("AdditionalConsumerDataRequest tag must be size equal two").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getAdditionalConsumerDataRequest).andThen(TagLengthString::getTag)).critical().must(StringPredicate.isNumeric(TagLengthString::getTag)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("AdditionalConsumerDataRequest tag must be number").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getAdditionalConsumerDataRequest).andThen(TagLengthString::getTag)).critical().must(StringPredicate.stringEquals(TagLengthString::getTag, (String)"09")).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage(String.format("AdditionalConsumerDataRequest tag must be '%s'", "09")).withAttempedValue(FunctionBuilder.of(AdditionalDataField::getAdditionalConsumerDataRequest).andThen(TagLengthString::getTag)).critical().must(LogicalPredicate.not((Predicate)StringPredicate.stringEmptyOrNull(TagLengthString::getValue))).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("AdditionalConsumerDataRequest value is mandatory").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getAdditionalConsumerDataRequest).andThen(TagLengthString::getValue)).critical().must(StringPredicate.stringSizeLessThanOrEqual(TagLengthString::getValue, (Integer)3)).when(LogicalPredicate.not((Predicate)ObjectPredicate.nullValue())).withMessage("AdditionalConsumerDataRequest value must less then or equal size three").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getAdditionalConsumerDataRequest).andThen(TagLengthString::getValue)).critical();
        this.ruleFor("RFUforEMVCo", AdditionalDataField::getRFUforEMVCo).must(ComparablePredicate.betweenInclusive(Map::size, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(39))).when(ComparablePredicate.greaterThan(Map::size, (Comparable)Integer.valueOf(0))).withMessage("RFUforEMVCo list size must be between one and thirty-nine").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getRFUforEMVCo).andThen(Map::size));
        ((WheneverCollection)this.ruleForEach(FunctionBuilder.of(AdditionalDataField::getRFUforEMVCo).andThen(Map::values)).whenever(ComparablePredicate.greaterThan(Collection::size, (Comparable)Integer.valueOf(0)))).withValidator((Validator)new TagLengthStringValidator("AdditionalDataField.RFUforEMVCo", "10", "49", 99));
        this.ruleFor("PaymentSystemSpecific", AdditionalDataField::getPaymentSystemSpecific).must(ComparablePredicate.betweenInclusive(Map::size, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(49))).when(ComparablePredicate.greaterThan(Map::size, (Comparable)Integer.valueOf(0))).withMessage("PaymentSystemSpecific list size must be between one and forty-nine").withAttempedValue(FunctionBuilder.of(AdditionalDataField::getPaymentSystemSpecific).andThen(Map::size));
        ((WheneverCollection)this.ruleForEach(FunctionBuilder.of(AdditionalDataField::getPaymentSystemSpecific).andThen(Map::values)).whenever(ComparablePredicate.greaterThan(Collection::size, (Comparable)Integer.valueOf(0)))).withValidator((Validator)new PaymentSystemSpecificTemplateValidator("50", "99", 99));
    }
}

