/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.model.mpm;

import com.emv.qrcode.core.CRC;
import com.emv.qrcode.core.model.TLV;
import com.emv.qrcode.core.model.mpm.TagLengthString;
import com.emv.qrcode.model.mpm.AdditionalDataFieldTemplate;
import com.emv.qrcode.model.mpm.MerchantAccountInformation;
import com.emv.qrcode.model.mpm.MerchantAccountInformationTemplate;
import com.emv.qrcode.model.mpm.MerchantInformationLanguageTemplate;
import com.emv.qrcode.model.mpm.UnreservedTemplate;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class MerchantPresentedMode
implements Serializable {
    private static final long serialVersionUID = 485352878727448583L;
    private TagLengthString payloadFormatIndicator;
    private TagLengthString pointOfInitiationMethod;
    private final Map<String, MerchantAccountInformationTemplate> merchantAccountInformation = new LinkedHashMap<String, MerchantAccountInformationTemplate>();
    private TagLengthString merchantCategoryCode;
    private TagLengthString transactionCurrency;
    private TagLengthString transactionAmount;
    private TagLengthString tipOrConvenienceIndicator;
    private TagLengthString valueOfConvenienceFeeFixed;
    private TagLengthString valueOfConvenienceFeePercentage;
    private TagLengthString countryCode;
    private TagLengthString merchantName;
    private TagLengthString merchantCity;
    private TagLengthString postalCode;
    private AdditionalDataFieldTemplate additionalDataField;
    private TagLengthString cRC;
    private MerchantInformationLanguageTemplate merchantInformationLanguage;
    private final Map<String, TagLengthString> rFUforEMVCo = new LinkedHashMap<String, TagLengthString>();
    private final Map<String, UnreservedTemplate> unreserveds = new LinkedHashMap<String, UnreservedTemplate>();

    public void setAdditionalDataField(AdditionalDataFieldTemplate additionalDataField) {
        this.additionalDataField = additionalDataField;
    }

    public void setMerchantInformationLanguage(MerchantInformationLanguageTemplate merchantInformationLanguage) {
        this.merchantInformationLanguage = merchantInformationLanguage;
    }

    public final void setPayloadFormatIndicator(String payloadFormatIndicator) {
        this.payloadFormatIndicator = new TagLengthString("00", payloadFormatIndicator);
    }

    public final void setPointOfInitiationMethod(String pointOfInitiationMethod) {
        this.pointOfInitiationMethod = new TagLengthString("01", pointOfInitiationMethod);
    }

    public final void setMerchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = new TagLengthString("52", merchantCategoryCode);
    }

    public final void setTransactionCurrency(String transactionCurrency) {
        this.transactionCurrency = new TagLengthString("53", transactionCurrency);
    }

    public final void setTransactionAmount(String transactionAmount) {
        this.transactionAmount = new TagLengthString("54", transactionAmount);
    }

    public final void setTipOrConvenienceIndicator(String tipOrConvenienceIndicator) {
        this.tipOrConvenienceIndicator = new TagLengthString("55", tipOrConvenienceIndicator);
    }

    public final void setValueOfConvenienceFeeFixed(String valueOfConvenienceFeeFixed) {
        this.valueOfConvenienceFeeFixed = new TagLengthString("56", valueOfConvenienceFeeFixed);
    }

    public final void setValueOfConvenienceFeePercentage(String valueOfConvenienceFeePercentage) {
        this.valueOfConvenienceFeePercentage = new TagLengthString("57", valueOfConvenienceFeePercentage);
    }

    public final void setCountryCode(String countryCode) {
        this.countryCode = new TagLengthString("58", countryCode);
    }

    public final void setMerchantName(String merchantName) {
        this.merchantName = new TagLengthString("59", merchantName);
    }

    public final void setMerchantCity(String merchantCity) {
        this.merchantCity = new TagLengthString("60", merchantCity);
    }

    public final void setPostalCode(String postalCode) {
        this.postalCode = new TagLengthString("61", postalCode);
    }

    public final void setCRC(String cRC) {
        this.cRC = new TagLengthString("63", cRC);
    }

    public final void addUnreserved(UnreservedTemplate unreserved) {
        this.unreserveds.put(unreserved.getTag(), unreserved);
    }

    public final void addMerchantAccountInformation(MerchantAccountInformationTemplate merchantAccountInformation) {
        this.merchantAccountInformation.put(merchantAccountInformation.getTag(), merchantAccountInformation);
    }

    public final void addRFUforEMVCo(TagLengthString rFUforEMVCo) {
        this.rFUforEMVCo.put(rFUforEMVCo.getTag(), rFUforEMVCo);
    }

    public String toHex() {
        return Hex.encodeHexString((byte[])this.toString().getBytes(StandardCharsets.UTF_8), (boolean)false);
    }

    public String toBase64() {
        return Base64.encodeBase64String((byte[])this.toString().getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.toStringWithoutCrc16());
        String string = sb.toString();
        if (StringUtils.isBlank((CharSequence)string)) {
            return "";
        }
        int crc16 = CRC.crc16(sb.toString().getBytes(StandardCharsets.UTF_8));
        sb.append(String.format("%04X", crc16));
        return sb.toString();
    }

    public String toStringWithoutCrc16() {
        StringBuilder sb = new StringBuilder();
        Optional.ofNullable(this.payloadFormatIndicator).ifPresent(tlv -> sb.append(tlv.toString()));
        Optional.ofNullable(this.pointOfInitiationMethod).ifPresent(tlv -> sb.append(tlv.toString()));
        for (Map.Entry<String, MerchantAccountInformationTemplate> entry : this.merchantAccountInformation.entrySet()) {
            Optional.ofNullable(entry.getValue()).ifPresent(tlv -> sb.append(tlv.toString()));
        }
        Optional.ofNullable(this.merchantCategoryCode).ifPresent(tlv -> sb.append(tlv.toString()));
        Optional.ofNullable(this.transactionCurrency).ifPresent(tlv -> sb.append(tlv.toString()));
        Optional.ofNullable(this.transactionAmount).ifPresent(tlv -> sb.append(tlv.toString()));
        Optional.ofNullable(this.tipOrConvenienceIndicator).ifPresent(tlv -> sb.append(tlv.toString()));
        Optional.ofNullable(this.valueOfConvenienceFeeFixed).ifPresent(tlv -> sb.append(tlv.toString()));
        Optional.ofNullable(this.valueOfConvenienceFeePercentage).ifPresent(tlv -> sb.append(tlv.toString()));
        Optional.ofNullable(this.countryCode).ifPresent(tlv -> sb.append(tlv.toString()));
        Optional.ofNullable(this.merchantName).ifPresent(tlv -> sb.append(tlv.toString()));
        Optional.ofNullable(this.merchantCity).ifPresent(tlv -> sb.append(tlv.toString()));
        Optional.ofNullable(this.postalCode).ifPresent(tlv -> sb.append(tlv.toString()));
        Optional.ofNullable(this.additionalDataField).ifPresent(tlv -> sb.append(tlv.toString()));
        Optional.ofNullable(this.merchantInformationLanguage).ifPresent(tlv -> sb.append(tlv.toString()));
        for (Map.Entry<String, TLV<String, MerchantAccountInformation>> entry : this.rFUforEMVCo.entrySet()) {
            Optional.ofNullable(entry.getValue()).ifPresent(tlv -> sb.append(tlv.toString()));
        }
        for (Map.Entry<String, TLV<String, MerchantAccountInformation>> entry : this.unreserveds.entrySet()) {
            Optional.ofNullable(entry.getValue()).ifPresent(tlv -> sb.append(tlv.toString()));
        }
        String string = sb.toString();
        if (StringUtils.isBlank((CharSequence)string)) {
            return "";
        }
        sb.append(String.format("%s%s", "63", "04"));
        return sb.toString();
    }

    @Generated
    public TagLengthString getPayloadFormatIndicator() {
        return this.payloadFormatIndicator;
    }

    @Generated
    public TagLengthString getPointOfInitiationMethod() {
        return this.pointOfInitiationMethod;
    }

    @Generated
    public Map<String, MerchantAccountInformationTemplate> getMerchantAccountInformation() {
        return this.merchantAccountInformation;
    }

    @Generated
    public TagLengthString getMerchantCategoryCode() {
        return this.merchantCategoryCode;
    }

    @Generated
    public TagLengthString getTransactionCurrency() {
        return this.transactionCurrency;
    }

    @Generated
    public TagLengthString getTransactionAmount() {
        return this.transactionAmount;
    }

    @Generated
    public TagLengthString getTipOrConvenienceIndicator() {
        return this.tipOrConvenienceIndicator;
    }

    @Generated
    public TagLengthString getValueOfConvenienceFeeFixed() {
        return this.valueOfConvenienceFeeFixed;
    }

    @Generated
    public TagLengthString getValueOfConvenienceFeePercentage() {
        return this.valueOfConvenienceFeePercentage;
    }

    @Generated
    public TagLengthString getCountryCode() {
        return this.countryCode;
    }

    @Generated
    public TagLengthString getMerchantName() {
        return this.merchantName;
    }

    @Generated
    public TagLengthString getMerchantCity() {
        return this.merchantCity;
    }

    @Generated
    public TagLengthString getPostalCode() {
        return this.postalCode;
    }

    @Generated
    public AdditionalDataFieldTemplate getAdditionalDataField() {
        return this.additionalDataField;
    }

    @Generated
    public TagLengthString getCRC() {
        return this.cRC;
    }

    @Generated
    public MerchantInformationLanguageTemplate getMerchantInformationLanguage() {
        return this.merchantInformationLanguage;
    }

    @Generated
    public Map<String, TagLengthString> getRFUforEMVCo() {
        return this.rFUforEMVCo;
    }

    @Generated
    public Map<String, UnreservedTemplate> getUnreserveds() {
        return this.unreserveds;
    }
}

