/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.mpm;

import com.emv.qrcode.core.configuration.DecodersMpmMap;
import com.emv.qrcode.core.exception.PresentedModeException;
import com.emv.qrcode.decoder.mpm.DecodeMpmIterator;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public abstract class DecoderMpm<T> {
    private static final Map<Class<?>, Constructor<? extends DecoderMpm<?>>> ctorMap = new ConcurrentHashMap();
    protected final Iterator<String> iterator;

    protected DecoderMpm(String source) {
        this.iterator = new DecodeMpmIterator(source);
    }

    protected abstract T decode() throws PresentedModeException;

    protected static <C, T> Map.Entry<Class<?>, BiConsumer<C, ?>> consumerTagLengthValue(Class<T> clazz, BiConsumer<C, T> consumer) {
        return new AbstractMap.SimpleEntry(clazz, consumer);
    }

    public static <T> T decode(String source, Class<T> clazz) throws PresentedModeException {
        try {
            Class<DecoderMpm<?>> parserClass = DecodersMpmMap.getDecoder(clazz);
            if (!ctorMap.containsKey(clazz)) {
                ctorMap.put(clazz, parserClass.getConstructor(String.class));
            }
            Constructor<DecoderMpm<?>> ctor = ctorMap.get(clazz);
            DecoderMpm<?> parser = ctor.newInstance(source);
            return clazz.cast(parser.decode());
        }
        catch (PresentedModeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

