/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.mpm;

import com.emv.qrcode.core.utils.TLVUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

final class DecodeMpmIterator
implements Iterator<String> {
    private Integer current = 0;
    private final Integer max;
    private final String source;

    public DecodeMpmIterator(String source) {
        this.max = source.length();
        this.source = source;
    }

    @Override
    public boolean hasNext() {
        if (this.current >= this.max) {
            return false;
        }
        Integer valueLength = TLVUtils.valueOfLength(this.source, this.current);
        return this.current + TLVUtils.ID_WORD_COUNT + TLVUtils.VALUE_LENGTH_WORD_COUNT + valueLength <= this.max;
    }

    @Override
    public void forEachRemaining(Consumer<? super String> action) {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String value = TLVUtils.chunk(this.source, this.current);
        this.current = this.current + value.length();
        return value;
    }
}

